/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0019H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/components/tilegroups/YieldGroup;", "Lcom/badlogic/gdx/scenes/scene2d/ui/HorizontalGroup;", "<init>", "()V", "currentStats", "Lcom/unciv/models/stats/Stats;", "getCurrentStats", "()Lcom/unciv/models/stats/Stats;", "setCurrentStats", "(Lcom/unciv/models/stats/Stats;)V", "setStats", "", "stats", "getIcon", "Lcom/unciv/ui/images/IconCircleGroup;", "statName", "", "getStatIconsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "number", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "", "act", "delta", "core"})
@SourceDebugExtension(value={"SMAP\nYieldGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YieldGroup.kt\ncom/unciv/ui/components/tilegroups/YieldGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class YieldGroup
extends HorizontalGroup {
    @NotNull
    private Stats currentStats;

    public YieldGroup() {
        this.setTransform(false);
        this.currentStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
    }

    @NotNull
    public final Stats getCurrentStats() {
        return this.currentStats;
    }

    public final void setCurrentStats(@NotNull Stats stats) {
        Intrinsics.checkNotNullParameter(stats, "<set-?>");
        this.currentStats = stats;
    }

    public final void setStats(@NotNull Stats stats) {
        Intrinsics.checkNotNullParameter(stats, "stats");
        if (this.currentStats.equals(stats)) {
            return;
        }
        this.currentStats = stats;
        this.clearChildren();
        for (Stats.StatValuePair statValuePair : stats) {
            Stat stat = statValuePair.component1();
            float amount = statValuePair.component2();
            if (!(amount > 0.0f)) continue;
            this.addActor(this.getStatIconsTable(stat.name(), (int)amount));
        }
        this.pack();
    }

    @NotNull
    public final IconCircleGroup getIcon(@NotNull String statName) {
        IconCircleGroup iconCircleGroup;
        Intrinsics.checkNotNullParameter(statName, "statName");
        IconCircleGroup $this$getIcon_u24lambda_u240 = iconCircleGroup = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, statName, 0.0f, 2, null), 12.0f, false, null, "StatIcons/Circle", 6, null);
        boolean bl = false;
        $this$getIcon_u24lambda_u240.getCircle().setColor(ImageGetter.INSTANCE.getCHARCOAL());
        $this$getIcon_u24lambda_u240.getCircle().getColor().a = 0.5f;
        return iconCircleGroup;
    }

    private final Table getStatIconsTable(String statName, int number) {
        Table table2 = new Table();
        switch (number) {
            case 1: {
                Cell<Actor> cell = table2.add((Actor)this.getIcon(statName));
                break;
            }
            case 2: {
                table2.add((Actor)this.getIcon(statName)).row();
                Cell<Actor> cell = table2.add((Actor)this.getIcon(statName));
                break;
            }
            case 3: {
                table2.add((Actor)this.getIcon(statName)).colspan(2).row();
                table2.add((Actor)this.getIcon(statName));
                Cell<Actor> cell = table2.add((Actor)this.getIcon(statName));
                break;
            }
            case 4: {
                table2.add((Actor)this.getIcon(statName));
                table2.add((Actor)this.getIcon(statName)).row();
                table2.add((Actor)this.getIcon(statName));
                Cell<Actor> cell = table2.add((Actor)this.getIcon(statName));
                break;
            }
            default: {
                Group group;
                Group $this$getStatIconsTable_u24lambda_u241 = group = new Group();
                boolean bl = false;
                $this$getStatIconsTable_u24lambda_u241.setSize(22.0f, 22.0f);
                Group group2 = group;
                Group $this$getStatIconsTable_u24lambda_u242 = $this$getStatIconsTable_u24lambda_u241 = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, statName, 0.0f, 2, null), 22.0f, false, null, null, 14, null);
                boolean bl22 = false;
                ((IconCircleGroup)$this$getStatIconsTable_u24lambda_u242).getCircle().setColor(ImageGetter.INSTANCE.getCHARCOAL());
                ((IconCircleGroup)$this$getStatIconsTable_u24lambda_u242).getCircle().getColor().a = 0.5f;
                Group largeImage = $this$getStatIconsTable_u24lambda_u241;
                Scene2dExtensionsKt.addToCenter(group2, largeImage);
                if (number > 5) {
                    String text = number < 10 ? TranslationsKt.tr(number) : "*";
                    Color color = Color.WHITE;
                    Intrinsics.checkNotNullExpressionValue(color, "WHITE");
                    Color bl22 = color;
                    Label label = Scene2dExtensionsKt.toLabel$default(text, bl22, 8, 1, false, 8, null);
                    IconCircleGroup amountGroup = Scene2dExtensionsKt.surroundWithCircle$default(label, 10.0f, true, ImageGetter.INSTANCE.getCHARCOAL(), null, 8, null);
                    label.setY(label.getY() - 0.5f);
                    amountGroup.setX(group2.getWidth() - amountGroup.getWidth() * (float)3 / (float)4);
                    amountGroup.setY(-amountGroup.getHeight() / (float)4);
                    group2.addActor(amountGroup);
                }
                Cell<Actor> cell = table2.add((Actor)group2);
            }
        }
        table2.pack();
        return table2;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }
}

