/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.translations;

import com.unciv.UncivGame;
import com.unciv.models.metadata.LocaleCode;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationActiveModsCache;
import com.unciv.models.translations.TranslationEntry;
import com.unciv.ui.components.fonts.FontRulesetIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\u001a \u0010\u000f\u001a\u00020\u0010*\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0007\u001a\u001c\u0010\u0014\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0003\u001a\u001c\u0010\u0016\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003\u001a$\u0010\u0017\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0003\u001a\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019*\u00020\u0010H\u0007\u001a\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0010H\u0007\u001a\u0014\u0010\u001b\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0007\u001a\f\u0010\u001d\u001a\u00020\u0012*\u00020\u0010H\u0007\u001a%\u0010\u001e\u001a\u00020\u0010*\u00020\u00102\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100 \"\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010!\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0019*\u00020\u0010H\u0007\u001a\f\u0010$\u001a\u00020\u0010*\u00020\u0010H\u0007\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020%H\u0007\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020%2\u0006\u0010\u0015\u001a\u00020\u0010H\u0007\"\u0017\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\u0005\"\u0017\u0010\t\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\u0005\"\u0017\u0010\f\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u0005\u00a8\u0006&"}, d2={"squareBraceRegex", "Lkotlin/text/Regex;", "getSquareBraceRegex$annotations", "()V", "getSquareBraceRegex", "()Lkotlin/text/Regex;", "curlyBraceRegex", "getCurlyBraceRegex$annotations", "getCurlyBraceRegex", "pointyBraceRegex", "getPointyBraceRegex$annotations", "getPointyBraceRegex", "digitsRegex", "getDigitsRegex$annotations", "getDigitsRegex", "tr", "", "hideIcons", "", "hideStats", "translateConditionals", "language", "translatePlaceholders", "translateIndividualWord", "getPlaceholderParameters", "", "getPlaceholderText", "equalsPlaceholderText", "str", "hasPlaceholderParameters", "fillPlaceholders", "strings", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getModifiers", "Lcom/unciv/models/ruleset/unique/Unique;", "removeConditionals", "", "core"})
@SourceDebugExtension(value={"SMAP\nTranslations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translations.kt\ncom/unciv/models/translations/TranslationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,593:1\n1563#2:594\n1634#2,3:595\n1869#2,2:599\n1869#2,2:601\n1869#2,2:603\n1#3:598\n*S KotlinDebug\n*F\n+ 1 Translations.kt\ncom/unciv/models/translations/TranslationsKt\n*L\n371#1:594\n371#1:595,3\n498#1:599,2\n515#1:601,2\n543#1:603,2\n*E\n"})
public final class TranslationsKt {
    @NotNull
    private static final Regex squareBraceRegex = new Regex("\\[([^]]*)\\]");
    @NotNull
    private static final Regex curlyBraceRegex = new Regex("\\{([^}]*)\\}");
    @NotNull
    private static final Regex pointyBraceRegex = new Regex("\\<([^>]*)\\>");
    @NotNull
    private static final Regex digitsRegex = new Regex("\\d");

    @NotNull
    public static final Regex getSquareBraceRegex() {
        return squareBraceRegex;
    }

    public static /* synthetic */ void getSquareBraceRegex$annotations() {
    }

    @NotNull
    public static final Regex getCurlyBraceRegex() {
        return curlyBraceRegex;
    }

    public static /* synthetic */ void getCurlyBraceRegex$annotations() {
    }

    @NotNull
    public static final Regex getPointyBraceRegex() {
        return pointyBraceRegex;
    }

    public static /* synthetic */ void getPointyBraceRegex$annotations() {
    }

    @NotNull
    public static final Regex getDigitsRegex() {
        return digitsRegex;
    }

    public static /* synthetic */ void getDigitsRegex$annotations() {
    }

    @Readonly
    @NotNull
    public static final String tr(@NotNull String $this$tr, boolean hideIcons, boolean hideStats) {
        boolean curlyBracketsEncounteredFirst;
        Intrinsics.checkNotNullParameter($this$tr, "<this>");
        String language = UncivGame.Companion.getCurrent().getSettings().getLanguage();
        if (StringsKt.contains$default((CharSequence)$this$tr, '<', false, 2, null) && StringsKt.contains$default((CharSequence)$this$tr, '>', false, 2, null) && pointyBraceRegex.containsMatchIn($this$tr)) {
            return TranslationsKt.translateConditionals($this$tr, hideIcons, language);
        }
        int indexSquare = StringsKt.indexOf$default((CharSequence)$this$tr, '[', 0, false, 6, null);
        int indexCurly = StringsKt.indexOf$default((CharSequence)$this$tr, '{', 0, false, 6, null);
        boolean squareBracketsEncounteredFirst = indexSquare >= 0 && (indexCurly < 0 || indexSquare < indexCurly);
        boolean bl = curlyBracketsEncounteredFirst = indexCurly >= 0 && (indexSquare < 0 || indexCurly < indexSquare);
        if (squareBracketsEncounteredFirst) {
            return TranslationsKt.translatePlaceholders($this$tr, language, hideIcons);
        }
        if (curlyBracketsEncounteredFirst) {
            return curlyBraceRegex.replace((CharSequence)$this$tr, arg_0 -> TranslationsKt.tr$lambda$0(hideIcons, arg_0));
        }
        return TranslationsKt.translateIndividualWord($this$tr, language, hideIcons, hideStats);
    }

    public static /* synthetic */ String tr$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return TranslationsKt.tr(string, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private static final String translateConditionals(String $this$translateConditionals, boolean hideIcons, String language) {
        Object object;
        void $this$mapTo$iv$iv;
        Object translatedBaseUnique = TranslationsKt.tr$default(TranslationsKt.removeConditionals($this$translateConditionals), hideIcons, false, 2, null);
        Iterable $this$map$iv = TranslationsKt.getModifiers($this$translateConditionals);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Unique unique = (Unique)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getPlaceholderText());
        }
        List conditionals = (List)destination$iv$iv;
        LinkedHashMap conditionsWithTranslation = new LinkedHashMap();
        for (Unique conditional : TranslationsKt.getModifiers($this$translateConditionals)) {
            ((Map)conditionsWithTranslation).put(conditional.getPlaceholderText(), TranslationsKt.tr$default(conditional.getText(), hideIcons, false, 2, null));
        }
        List translatedConditionals = new ArrayList();
        String conditionalOrdering = UncivGame.Companion.getCurrent().getTranslations().getConditionalOrder(language);
        destination$iv$iv = SequencesKt.map(Regex.findAll$default(pointyBraceRegex, conditionalOrdering, 0, 2, null), TranslationsKt::translateConditionals$lambda$2).iterator();
        while (destination$iv$iv.hasNext()) {
            String placedConditional = (String)destination$iv$iv.next();
            if (!conditionals.contains(placedConditional)) continue;
            Object v = conditionsWithTranslation.get(placedConditional);
            Intrinsics.checkNotNull(v);
            translatedConditionals.add(v);
            conditionsWithTranslation.remove(placedConditional);
        }
        Collection collection = conditionsWithTranslation.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        translatedConditionals.addAll(collection);
        if (UncivGame.Companion.getCurrent().getTranslations().placeConditionalsAfterUnique(language)) {
            translatedConditionals.add(0, translatedBaseUnique);
        } else {
            if (UncivGame.Companion.getCurrent().getTranslations().shouldCapitalize(language) && Character.isUpperCase(((String)translatedBaseUnique).charAt(0))) {
                Object object2;
                destination$iv$iv = translatedBaseUnique;
                if (((CharSequence)destination$iv$iv).length() > 0) {
                    void it;
                    char placedConditional = ((String)destination$iv$iv).charAt(0);
                    object = new StringBuilder();
                    int n = 0;
                    String string = String.valueOf((char)it);
                    Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    StringBuilder stringBuilder = ((StringBuilder)object).append((Object)string2);
                    Object object3 = destination$iv$iv;
                    n = 1;
                    String string3 = ((String)object3).substring(n);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    object2 = stringBuilder.append(string3).toString();
                } else {
                    object2 = destination$iv$iv;
                }
                translatedBaseUnique = object2;
            }
            translatedConditionals.add(translatedBaseUnique);
        }
        String fullyTranslatedString = CollectionsKt.joinToString$default(translatedConditionals, UncivGame.Companion.getCurrent().getTranslations().getSpaceEquivalent(language), null, null, 0, null, null, 62, null);
        if (UncivGame.Companion.getCurrent().getTranslations().shouldCapitalize(language)) {
            String string;
            String string4 = fullyTranslatedString;
            if (((CharSequence)string4).length() > 0) {
                void it;
                char n = string4.charAt(0);
                object = new StringBuilder();
                boolean bl = false;
                String string5 = String.valueOf((char)it);
                Intrinsics.checkNotNull(string5, "null cannot be cast to non-null type java.lang.String");
                String string6 = string5.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string6, "toUpperCase(...)");
                StringBuilder stringBuilder = ((StringBuilder)object).append((Object)string6);
                String string7 = string4;
                int n2 = 1;
                String string8 = string7.substring(n2);
                Intrinsics.checkNotNullExpressionValue(string8, "substring(...)");
                string = stringBuilder.append(string8).toString();
            } else {
                string = string4;
            }
            fullyTranslatedString = string;
        }
        return fullyTranslatedString;
    }

    @Readonly
    private static final String translatePlaceholders(String $this$translatePlaceholders, String language, boolean hideIcons) {
        String translationStringWithSquareBracketsOnly = TranslationsKt.getPlaceholderText($this$translatePlaceholders);
        TranslationEntry translationEntry = UncivGame.Companion.getCurrent().getTranslations().get(translationStringWithSquareBracketsOnly, language, TranslationActiveModsCache.INSTANCE.getActiveMods());
        String languageSpecificPlaceholder = null;
        String originalEntry = null;
        if (translationEntry == null || !translationEntry.containsKey((Object)language)) {
            languageSpecificPlaceholder = $this$translatePlaceholders;
            originalEntry = $this$translatePlaceholders;
        } else {
            Object object = translationEntry.get((Object)language);
            Intrinsics.checkNotNull(object);
            languageSpecificPlaceholder = (String)object;
            originalEntry = translationEntry.getEntry();
        }
        List<String> termsInMessage = TranslationsKt.getPlaceholderParameters($this$translatePlaceholders);
        List<String> termsInTranslationPlaceholder = TranslationsKt.getPlaceholderParameters(originalEntry);
        if (termsInMessage.size() != termsInTranslationPlaceholder.size()) {
            throw new Exception("Message " + $this$translatePlaceholders + " has a different number of terms than the placeholder " + translationEntry + '!');
        }
        int n = ((Collection)termsInMessage).size();
        for (int i = 0; i < n; ++i) {
            languageSpecificPlaceholder = StringsKt.replace$default(languageSpecificPlaceholder, '[' + termsInTranslationPlaceholder.get(i) + ']', TranslationsKt.tr$default(termsInMessage.get(i), hideIcons, false, 2, null), false, 4, null);
        }
        return languageSpecificPlaceholder;
    }

    @Readonly
    private static final String translateIndividualWord(String $this$translateIndividualWord, String language, boolean hideIcons, boolean hideStats) {
        if (Stats.Companion.isStats($this$translateIndividualWord)) {
            return Stats.Companion.parse($this$translateIndividualWord).toString();
        }
        CharSequence charSequence = UncivGame.Companion.getCurrent().getTranslations().getText($this$translateIndividualWord, language, TranslationActiveModsCache.INSTANCE.getActiveMods());
        Regex regex = digitsRegex;
        Function1<MatchResult, CharSequence> function1 = arg_0 -> TranslationsKt.translateIndividualWord$lambda$5(language, arg_0);
        String translation = regex.replace(charSequence, function1);
        Stat stat = Stat.Companion.safeValueOf($this$translateIndividualWord);
        if (!hideStats && stat != null) {
            char c = stat.getCharacter();
            return c + translation;
        }
        if (!hideIcons && FontRulesetIcons.INSTANCE.getRulesetObjectNameToChar().containsKey($this$translateIndividualWord)) {
            Character c = FontRulesetIcons.INSTANCE.getRulesetObjectNameToChar().get($this$translateIndividualWord);
            Intrinsics.checkNotNull(c);
            char c2 = c.charValue();
            return c2 + translation;
        }
        return translation;
    }

    @Pure
    @NotNull
    public static final List<String> getPlaceholderParameters(@NotNull String $this$getPlaceholderParameters) {
        Intrinsics.checkNotNullParameter($this$getPlaceholderParameters, "<this>");
        if (!StringsKt.contains$default((CharSequence)$this$getPlaceholderParameters, '[', false, 2, null)) {
            return CollectionsKt.emptyList();
        }
        String stringToParse = TranslationsKt.removeConditionals($this$getPlaceholderParameters);
        ArrayList<String> parameters = new ArrayList<String>();
        int depthOfBraces = 0;
        int startOfCurrentParameter = 0;
        startOfCurrentParameter = -1;
        Iterable $this$forEach$iv = StringsKt.getIndices(stringToParse);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (stringToParse.charAt(i) == '[') {
                if (depthOfBraces == 0) {
                    startOfCurrentParameter = i + 1;
                }
                ++depthOfBraces;
            }
            if (stringToParse.charAt(i) != ']' || depthOfBraces <= 0 || (depthOfBraces += -1) != 0) continue;
            String string = $this$getPlaceholderParameters.substring(startOfCurrentParameter, i);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            parameters.add(string);
        }
        return parameters;
    }

    @Pure
    @NotNull
    public static final String getPlaceholderText(@NotNull String $this$getPlaceholderText) {
        Intrinsics.checkNotNullParameter($this$getPlaceholderText, "<this>");
        String stringToReturn = null;
        stringToReturn = TranslationsKt.removeConditionals($this$getPlaceholderText);
        List<String> placeholderParameters = TranslationsKt.getPlaceholderParameters(stringToReturn);
        Iterable $this$forEach$iv = placeholderParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String placeholderParameter = (String)element$iv;
            boolean bl = false;
            stringToReturn = StringsKt.replaceFirst$default(stringToReturn, '[' + placeholderParameter + ']', "[]", false, 4, null);
        }
        return stringToReturn;
    }

    @Pure
    public static final boolean equalsPlaceholderText(@NotNull String $this$equalsPlaceholderText, @NotNull String str) {
        Intrinsics.checkNotNullParameter($this$equalsPlaceholderText, "<this>");
        Intrinsics.checkNotNullParameter(str, "str");
        if (((CharSequence)$this$equalsPlaceholderText).length() == 0) {
            return ((CharSequence)str).length() == 0;
        }
        if (((CharSequence)str).length() == 0) {
            return false;
        }
        if (StringsKt.first($this$equalsPlaceholderText) != StringsKt.first(str)) {
            return false;
        }
        return Intrinsics.areEqual(TranslationsKt.getPlaceholderText($this$equalsPlaceholderText), str);
    }

    @Pure
    public static final boolean hasPlaceholderParameters(@NotNull String $this$hasPlaceholderParameters) {
        Intrinsics.checkNotNullParameter($this$hasPlaceholderParameters, "<this>");
        if (!StringsKt.contains$default((CharSequence)$this$hasPlaceholderParameters, '[', false, 2, null)) {
            return false;
        }
        return squareBraceRegex.containsMatchIn(TranslationsKt.removeConditionals($this$hasPlaceholderParameters));
    }

    @Pure
    @NotNull
    public static final String fillPlaceholders(@NotNull String $this$fillPlaceholders, String ... strings) {
        Intrinsics.checkNotNullParameter($this$fillPlaceholders, "<this>");
        Intrinsics.checkNotNullParameter(strings, "strings");
        List<String> keys2 = TranslationsKt.getPlaceholderParameters($this$fillPlaceholders);
        if (keys2.size() > strings.length) {
            throw new Exception("String " + $this$fillPlaceholders + " has a different number of placeholders " + CollectionsKt.joinToString$default(keys2, null, null, null, 0, null, null, 63, null) + " (" + keys2.size() + ") than the substitutive strings " + ArraysKt.joinToString$default(strings, null, null, null, 0, null, null, 63, null) + " (" + strings.length + ")!");
        }
        String filledString = null;
        CharSequence charSequence = $this$fillPlaceholders;
        Regex regex = squareBraceRegex;
        Object object = "[]";
        filledString = regex.replace(charSequence, (String)object);
        Iterable $this$forEach$iv = CollectionsKt.getIndices((Collection)keys2);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            filledString = StringsKt.replaceFirst$default(filledString, "[]", '[' + strings[i] + ']', false, 4, null);
        }
        return filledString;
    }

    @Pure
    @NotNull
    public static final List<Unique> getModifiers(@NotNull String $this$getModifiers) {
        Intrinsics.checkNotNullParameter($this$getModifiers, "<this>");
        if (!StringsKt.contains$default((CharSequence)$this$getModifiers, '<', false, 2, null)) {
            return CollectionsKt.emptyList();
        }
        Sequence matchResults = Regex.findAll$default(pointyBraceRegex, $this$getModifiers, 0, 2, null);
        Sequence<Unique> uniques = SequencesKt.map(matchResults, TranslationsKt::getModifiers$lambda$9);
        return SequencesKt.toList(uniques);
    }

    @Pure
    @NotNull
    public static final String removeConditionals(@NotNull String $this$removeConditionals) {
        Intrinsics.checkNotNullParameter($this$removeConditionals, "<this>");
        if (!StringsKt.contains$default((CharSequence)$this$removeConditionals, '<', false, 2, null)) {
            return $this$removeConditionals;
        }
        CharSequence charSequence = $this$removeConditionals;
        Regex regex = pointyBraceRegex;
        String string = "";
        return ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default(regex.replace(charSequence, string), "  ", " ", false, 4, null))).toString();
    }

    @Readonly
    @NotNull
    public static final String tr(@NotNull Number $this$tr) {
        Intrinsics.checkNotNullParameter($this$tr, "<this>");
        String string = UncivGame.Companion.getCurrent().getSettings().getCurrentNumberFormat().format($this$tr);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @Readonly
    @NotNull
    public static final String tr(@NotNull Number $this$tr, @NotNull String language) {
        Intrinsics.checkNotNullParameter($this$tr, "<this>");
        Intrinsics.checkNotNullParameter(language, "language");
        String string = LocaleCode.Companion.getNumberFormatFromLanguage(language).format($this$tr);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    private static final CharSequence tr$lambda$0(boolean $hideIcons, MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        MatchGroup matchGroup = it.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        return TranslationsKt.tr$default(matchGroup.getValue(), $hideIcons, false, 2, null);
    }

    private static final String translateConditionals$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.getValue().substring(1, it.getValue().length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return TranslationsKt.getPlaceholderText(string);
    }

    private static final CharSequence translateIndividualWord$lambda$5(String $language, MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr(Long.parseLong(it.getValue()), $language);
    }

    private static final Unique getModifiers$lambda$9(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        MatchGroup matchGroup = it.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        return new Unique(matchGroup.getValue(), null, null, 6, null);
    }
}

