/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique.expressions;

import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.expressions.Node;
import com.unciv.models.ruleset.unique.expressions.Operator;
import com.unciv.models.ruleset.unique.expressions.Tokenizer;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser;", "", "<init>", "()V", "eval", "", "text", "", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "parse", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "parse$core", "getASTDebugDescription", "ParsingError", "SyntaxError", "UnmatchedBraces", "EmptyBraces", "UnmatchedParentheses", "UnexpectedToken", "MissingOperand", "InvalidConstant", "UnknownIdentifier", "EmptyExpression", "StartToken", "EndToken", "StateEngine", "core"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    public final double eval(@NotNull String text, @NotNull GameContext context) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.parse$core(text).eval(context);
    }

    public static /* synthetic */ double eval$default(Parser parser, String string, GameContext gameContext, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = GameContext.Companion.getEmptyState();
        }
        return parser.eval(string, gameContext);
    }

    @Readonly
    @NotNull
    public final Node parse$core(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Sequence<Pair> tokens = SequencesKt.map(Tokenizer.INSTANCE.tokenize(text), Parser::parse$lambda$0);
        StateEngine engine = new StateEngine(tokens);
        return engine.buildAST();
    }

    @VisibleForTesting
    @NotNull
    public final String getASTDebugDescription(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return this.parse$core(text).toString();
    }

    private static final Pair parse$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Tokenizer.INSTANCE.toToken(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$EmptyBraces;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "position", "", "<init>", "(I)V", "core"})
    public static final class EmptyBraces
    extends ParsingError {
        public EmptyBraces(int position) {
            super("Empty square braces", position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$EmptyExpression;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "<init>", "()V", "core"})
    public static final class EmptyExpression
    extends ParsingError {
        public EmptyExpression() {
            super("Empty expression", 0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c2\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$EndToken;", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "<init>", "()V", "toString", "", "equals", "", "other", "", "hashCode", "", "core"})
    private static final class EndToken
    implements Tokenizer.Token {
        @NotNull
        public static final EndToken INSTANCE = new EndToken();

        private EndToken() {
        }

        @NotNull
        public String toString() {
            return "end of expression";
        }

        public int hashCode() {
            return 973538341;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EndToken)) {
                return false;
            }
            EndToken cfr_ignored_0 = (EndToken)other;
            return true;
        }

        @Override
        @Pure
        public boolean canBeUnary() {
            return Tokenizer.Token.super.canBeUnary();
        }

        @Override
        @Pure
        public boolean canBeBinary() {
            return Tokenizer.Token.super.canBeBinary();
        }

        @Override
        @Pure
        @NotNull
        public Operator.Unary fetchUnaryOperator() {
            return Tokenizer.Token.super.fetchUnaryOperator();
        }

        @Override
        @Pure
        @NotNull
        public Operator.Binary fetchBinaryOperator() {
            return Tokenizer.Token.super.fetchBinaryOperator();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$InvalidConstant;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$SyntaxError;", "position", "", "text", "", "<init>", "(ILjava/lang/String;)V", "core"})
    public static final class InvalidConstant
    extends SyntaxError {
        public InvalidConstant(int position, @NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            super("Invalid constant: " + text, position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$MissingOperand;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$SyntaxError;", "position", "", "<init>", "(I)V", "core"})
    public static final class MissingOperand
    extends SyntaxError {
        public MissingOperand(int position) {
            super("Missing operand", position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "position", "", "<init>", "(Ljava/lang/String;I)V", "getMessage", "()Ljava/lang/String;", "getPosition", "()I", "core"})
    public static class ParsingError
    extends Exception {
        @NotNull
        private final String message;
        private final int position;

        public ParsingError(@NotNull String message, int position) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.message = message;
            this.position = position;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        public final int getPosition() {
            return this.position;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c2\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$StartToken;", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "<init>", "()V", "toString", "", "equals", "", "other", "", "hashCode", "", "core"})
    private static final class StartToken
    implements Tokenizer.Token {
        @NotNull
        public static final StartToken INSTANCE = new StartToken();

        private StartToken() {
        }

        @NotNull
        public String toString() {
            return "start of expression";
        }

        public int hashCode() {
            return -1399492802;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StartToken)) {
                return false;
            }
            StartToken cfr_ignored_0 = (StartToken)other;
            return true;
        }

        @Override
        @Pure
        public boolean canBeUnary() {
            return Tokenizer.Token.super.canBeUnary();
        }

        @Override
        @Pure
        public boolean canBeBinary() {
            return Tokenizer.Token.super.canBeBinary();
        }

        @Override
        @Pure
        @NotNull
        public Operator.Unary fetchUnaryOperator() {
            return Tokenizer.Token.super.fetchUnaryOperator();
        }

        @Override
        @Pure
        @NotNull
        public Operator.Binary fetchBinaryOperator() {
            return Tokenizer.Token.super.fetchBinaryOperator();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0007R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$StateEngine;", "", "input", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "<init>", "(Lkotlin/sequences/Sequence;)V", "currentToken", "currentPosition", "iterator", "", "openParenthesesCount", "expect", "", "expected", "next", "handleUnary", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "expression", "minPrecedence", "fetchOperand", "buildAST", "core"})
    private static final class StateEngine {
        @NotNull
        private Tokenizer.Token currentToken;
        private int currentPosition;
        @NotNull
        private final Iterator<Pair<Integer, Tokenizer.Token>> iterator;
        private int openParenthesesCount;

        public StateEngine(@NotNull Sequence<? extends Pair<Integer, ? extends Tokenizer.Token>> input2) {
            Intrinsics.checkNotNullParameter(input2, "input");
            this.currentToken = StartToken.INSTANCE;
            this.iterator = input2.iterator();
        }

        private final void expect(Tokenizer.Token expected) {
            if (Intrinsics.areEqual(this.currentToken, expected)) {
                return;
            }
            if (expected == Operator.Parentheses.Closing && Intrinsics.areEqual(this.currentToken, EndToken.INSTANCE)) {
                String string = "Opening".toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                throw new UnmatchedParentheses(this.currentPosition, string);
            }
            if (Intrinsics.areEqual(expected, EndToken.INSTANCE) && this.currentToken == Operator.Parentheses.Closing) {
                String string = "Closing".toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                throw new UnmatchedParentheses(this.currentPosition, string);
            }
            throw new UnexpectedToken(this.currentPosition, expected, this.currentToken);
        }

        private final void next() {
            int n;
            if (this.currentToken == Operator.Parentheses.Opening) {
                n = this.openParenthesesCount;
                this.openParenthesesCount = n + 1;
            } else if (this.currentToken == Operator.Parentheses.Closing) {
                if (this.openParenthesesCount == 0) {
                    String string = "Closing".toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    throw new UnmatchedParentheses(this.currentPosition, string);
                }
                n = this.openParenthesesCount;
                this.openParenthesesCount = n + -1;
            }
            if (this.iterator.hasNext()) {
                Tokenizer.Token token2;
                Pair<Integer, Tokenizer.Token> pair = this.iterator.next();
                int position = ((Number)pair.component1()).intValue();
                this.currentToken = token2 = pair.component2();
                this.currentPosition = position;
            } else {
                this.currentToken = EndToken.INSTANCE;
            }
        }

        private final Node handleUnary() {
            Operator.Unary operator = this.currentToken.fetchUnaryOperator();
            this.next();
            return new Node.UnaryOperation(operator, this.fetchOperand());
        }

        private final Node expression(int minPrecedence) {
            Operator.Binary operator;
            Node result2 = this.fetchOperand();
            while (this.currentToken.canBeBinary() && (operator = this.currentToken.fetchBinaryOperator()).getPrecedence() >= minPrecedence) {
                this.next();
                int newPrecedence = operator.isLeftAssociative() ? operator.getPrecedence() + 1 : operator.getPrecedence();
                result2 = new Node.BinaryOperation(operator, result2, this.expression(newPrecedence));
            }
            return result2;
        }

        static /* synthetic */ Node expression$default(StateEngine stateEngine, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return stateEngine.expression(n);
        }

        private final Node fetchOperand() {
            if (Intrinsics.areEqual(this.currentToken, StartToken.INSTANCE)) {
                this.next();
            }
            if (this.currentToken.canBeUnary()) {
                return this.handleUnary();
            }
            if (this.currentToken == Operator.Parentheses.Opening) {
                this.next();
                Node node = StateEngine.expression$default(this, 0, 1, null);
                this.expect(Operator.Parentheses.Closing);
                this.next();
                return node;
            }
            if (this.currentToken instanceof Node.Constant || this.currentToken instanceof Node.Countable) {
                Tokenizer.Token token2 = this.currentToken;
                Intrinsics.checkNotNull(token2, "null cannot be cast to non-null type com.unciv.models.ruleset.unique.expressions.Node");
                Node node = (Node)((Object)token2);
                this.next();
                return node;
            }
            throw new MissingOperand(this.currentPosition);
        }

        @Pure
        @NotNull
        public final Node buildAST() {
            Node node = StateEngine.expression$default(this, 0, 1, null);
            this.expect(EndToken.INSTANCE);
            return node;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$SyntaxError;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "message", "", "position", "", "<init>", "(Ljava/lang/String;I)V", "core"})
    public static class SyntaxError
    extends ParsingError {
        public SyntaxError(@NotNull String message, int position) {
            Intrinsics.checkNotNullParameter(message, "message");
            super(message, position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$UnexpectedToken;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "position", "", "expected", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "found", "<init>", "(ILcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;)V", "core"})
    public static final class UnexpectedToken
    extends ParsingError {
        public UnexpectedToken(int position, @NotNull Tokenizer.Token expected, @NotNull Tokenizer.Token found) {
            Intrinsics.checkNotNullParameter(expected, "expected");
            Intrinsics.checkNotNullParameter(found, "found");
            super("Unexpected token: " + found + " instead of " + expected, position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$UnknownIdentifier;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "position", "", "text", "", "<init>", "(ILjava/lang/String;)V", "core"})
    public static final class UnknownIdentifier
    extends ParsingError {
        public UnknownIdentifier(int position, @NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            super("Unknown identifier: \"" + text + '\"', position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$UnmatchedBraces;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$ParsingError;", "position", "", "<init>", "(I)V", "core"})
    public static final class UnmatchedBraces
    extends ParsingError {
        public UnmatchedBraces(int position) {
            super("Unmatched square braces", position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Parser$UnmatchedParentheses;", "Lcom/unciv/models/ruleset/unique/expressions/Parser$SyntaxError;", "position", "", "name", "", "<init>", "(ILjava/lang/String;)V", "core"})
    public static final class UnmatchedParentheses
    extends SyntaxError {
        public UnmatchedParentheses(int position, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            super("Unmatched " + name + " parenthesis", position);
        }
    }
}

