/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.mapregions.MapGenTileData;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ>\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013H\u0002J>\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013H\u0002J0\u0010\u0016\u001a\u00020\u00052\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006 "}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/RegionStartFinder;", "", "<init>", "()V", "findStart", "", "region", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "findStart$core", "findGoodPosition", "", "centerTiles", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/Tile;", "fallbackTiles", "Ljava/util/HashSet;", "Lcom/badlogic/gdx/math/Vector2;", "Lkotlin/collections/HashSet;", "findEdgePosition", "outerDonut", "findFallbackPosition", "getCentralRectangle", "Lcom/badlogic/gdx/math/Rectangle;", "originalRect", "proportion", "", "evaluateTileForStart", "tile", "setRegionStart", "position", "core"})
@SourceDebugExtension(value={"SMAP\nRegionStartFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionStartFinder.kt\ncom/unciv/logic/map/mapgenerator/mapregions/RegionStartFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1761#2,3:236\n774#2:239\n865#2,2:240\n1999#2,14:242\n1999#2,14:256\n1761#2,3:270\n774#2:273\n865#2,2:274\n2423#2,14:276\n1999#2,14:290\n1999#2,14:304\n230#2,2:318\n*S KotlinDebug\n*F\n+ 1 RegionStartFinder.kt\ncom/unciv/logic/map/mapgenerator/mapregions/RegionStartFinder\n*L\n64#1:236,3\n66#1:239\n66#1:240,2\n66#1:242,14\n70#1:256,14\n92#1:270,3\n95#1:273\n95#1:274,2\n96#1:276,14\n113#1:290,14\n123#1:304,14\n131#1:318,2\n*E\n"})
public final class RegionStartFinder {
    @NotNull
    public static final RegionStartFinder INSTANCE = new RegionStartFinder();

    private RegionStartFinder() {
    }

    public final void findStart$core(@NotNull Region region, @NotNull TileDataMap tileData) {
        Intrinsics.checkNotNullParameter(region, "region");
        Intrinsics.checkNotNullParameter(tileData, "tileData");
        HashSet<Vector2> fallbackTiles = new HashSet<Vector2>();
        Sequence<Tile> centerTiles = region.getTileMap().getTilesInRectangle(this.getCentralRectangle(region.getRect(), 0.33f));
        if (this.findGoodPosition(centerTiles, region, tileData, fallbackTiles)) {
            return;
        }
        Sequence<Tile> middleDonut = SequencesKt.filterNot(region.getTileMap().getTilesInRectangle(this.getCentralRectangle(region.getRect(), 0.67f)), arg_0 -> RegionStartFinder.findStart$lambda$0(centerTiles, arg_0));
        if (this.findGoodPosition(middleDonut, region, tileData, fallbackTiles)) {
            return;
        }
        Sequence<Tile> outerDonut = SequencesKt.filterNot(region.getTileMap().getTilesInRectangle(region.getRect()), arg_0 -> RegionStartFinder.findStart$lambda$1(centerTiles, middleDonut, arg_0));
        if (this.findEdgePosition(outerDonut, region, tileData, fallbackTiles)) {
            return;
        }
        this.findFallbackPosition(fallbackTiles, tileData, region);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findGoodPosition(Sequence<Tile> centerTiles, Region region, TileDataMap tileData, HashSet<Vector2> fallbackTiles) {
        Object tile;
        HashSet<Vector2> riverTiles = new HashSet<Vector2>();
        HashSet<Vector2> wetTiles = new HashSet<Vector2>();
        HashSet<Vector2> dryTiles = new HashSet<Vector2>();
        Iterator<Object> iterator2 = centerTiles.iterator();
        while (iterator2.hasNext()) {
            tile = iterator2.next();
            Object object = tileData.get((Object)((Tile)tile).getPosition());
            Intrinsics.checkNotNull(object);
            if (((MapGenTileData)object).isTwoFromCoast() || region.getContinentID() != -1 && region.getContinentID() != ((Tile)tile).getContinent() || !((Tile)tile).isLand() || ((Tile)tile).isImpassible()) continue;
            this.evaluateTileForStart((Tile)tile, tileData);
            boolean bl = ((Tile)tile).isAdjacentToRiver() ? riverTiles.add(((Tile)tile).getPosition()) : (((Tile)tile).isCoastalTile() || Tile.isAdjacentTo$default((Tile)tile, "Fresh water", null, 2, null) ? wetTiles.add(((Tile)tile).getPosition()) : dryTiles.add(((Tile)tile).getPosition()));
        }
        tile = new HashSet[]{riverTiles, wetTiles, dryTiles};
        iterator2 = SequencesKt.sequenceOf(tile).iterator();
        while (iterator2.hasNext()) {
            Object e;
            Object maxElem$iv;
            Iterator iterator$iv;
            Iterable $this$maxByOrNull$iv;
            boolean $i$f$maxByOrNull;
            Object object;
            Vector2 it;
            boolean bl;
            Iterable $this$any$iv;
            HashSet list2;
            block17: {
                list2 = (HashSet)iterator2.next();
                $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Vector2)element$iv;
                        boolean bl2 = false;
                        Object object2 = tileData.get((Object)it);
                        Intrinsics.checkNotNull(object2);
                        if (!((MapGenTileData)object2).isGoodStart()) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Object v5;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$any$iv = list2;
                Region region2 = region;
                object = this;
                boolean $i$f$filter = false;
                Iterator iterator3 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Vector2 it2 = (Vector2)element$iv$iv;
                    boolean bl3 = false;
                    Object object3 = tileData.get((Object)it2);
                    Intrinsics.checkNotNull(object3);
                    if (!((MapGenTileData)object3).isGoodStart()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                $this$filter$iv = list3;
                $i$f$maxByOrNull = false;
                iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v5 = null;
                } else {
                    maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v5 = maxElem$iv;
                    } else {
                        Vector2 it3 = (Vector2)maxElem$iv;
                        boolean bl4 = false;
                        Object object4 = tileData.get((Object)it3);
                        Intrinsics.checkNotNull(object4);
                        int maxValue$iv = ((MapGenTileData)object4).getStartScore();
                        do {
                            Object e$iv = iterator$iv.next();
                            Vector2 it4 = (Vector2)e$iv;
                            $i$a$-maxByOrNull-RegionStartFinder$findGoodPosition$3 = false;
                            Object object5 = tileData.get((Object)it4);
                            Intrinsics.checkNotNull(object5);
                            int v$iv = ((MapGenTileData)object5).getStartScore();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v5 = maxElem$iv;
                    }
                }
                List list4 = list3 = v5;
                Intrinsics.checkNotNull(list4);
                super.setRegionStart(region2, (Vector2)((Object)list4), tileData);
                return true;
            }
            if (!(!((Collection)list2).isEmpty())) continue;
            $this$maxByOrNull$iv = list2;
            object = fallbackTiles;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                e = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    e = maxElem$iv;
                } else {
                    it = (Vector2)maxElem$iv;
                    boolean bl5 = false;
                    Object object6 = tileData.get((Object)it);
                    Intrinsics.checkNotNull(object6);
                    int maxValue$iv = ((MapGenTileData)object6).getStartScore();
                    do {
                        Object e$iv = iterator$iv.next();
                        Vector2 it5 = (Vector2)e$iv;
                        $i$a$-maxByOrNull-RegionStartFinder$findGoodPosition$4 = false;
                        Object object7 = tileData.get((Object)it5);
                        Intrinsics.checkNotNull(object7);
                        int v$iv = ((MapGenTileData)object7).getStartScore();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    e = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(e);
            ((HashSet)object).add(e);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findEdgePosition(Sequence<Tile> outerDonut, Region region, TileDataMap tileData, HashSet<Vector2> fallbackTiles) {
        Object center;
        Object it;
        boolean bl;
        HashSet<Vector2> dryTiles;
        block21: {
            dryTiles = new HashSet<Vector2>();
            Iterator<Tile> iterator2 = outerDonut.iterator();
            while (iterator2.hasNext()) {
                Tile tile = iterator2.next();
                if (region.getContinentID() != -1 && region.getContinentID() != tile.getContinent() || !tile.isLand() || tile.isImpassible()) continue;
                this.evaluateTileForStart(tile, tileData);
                dryTiles.add(tile.getPosition());
            }
            Iterable $this$any$iv = dryTiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Vector2)element$iv;
                    boolean bl2 = false;
                    Object object = tileData.get(it);
                    Intrinsics.checkNotNull(object);
                    if (!((MapGenTileData)object).isGoodStart()) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl) {
            Object v3;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            center = region.getRect().getCenter(new Vector2());
            Iterable $this$filter$iv = dryTiles;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Vector2 it2 = (Vector2)element$iv$iv;
                boolean bl3 = false;
                Object object = tileData.get((Object)it2);
                Intrinsics.checkNotNull(object);
                if (!((MapGenTileData)object).isGoodStart()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    Tile tile;
                    Vector2 it3 = (Vector2)minElem$iv;
                    boolean bl4 = false;
                    Tile tile2 = region.getTileMap().getIfTileExistsOrNull(MathKt.roundToInt(((Vector2)center).x), MathKt.roundToInt(((Vector2)center).y));
                    if (tile2 == null) {
                        tile2 = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                    }
                    if ((tile = region.getTileMap().getIfTileExistsOrNull((int)it3.x, (int)it3.y)) == null) {
                        tile = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                    }
                    int minValue$iv = tile2.aerialDistanceTo(tile);
                    do {
                        int v$iv;
                        Tile tile3;
                        Object e$iv = iterator$iv.next();
                        Vector2 it4 = (Vector2)e$iv;
                        $i$a$-minByOrNull-RegionStartFinder$findEdgePosition$closestToCenter$2 = false;
                        Tile tile4 = region.getTileMap().getIfTileExistsOrNull(MathKt.roundToInt(((Vector2)center).x), MathKt.roundToInt(((Vector2)center).y));
                        if (tile4 == null) {
                            tile4 = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                        }
                        if ((tile3 = region.getTileMap().getIfTileExistsOrNull((int)it4.x, (int)it4.y)) == null) {
                            tile3 = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                        }
                        if (minValue$iv <= (v$iv = tile4.aerialDistanceTo(tile3))) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v3);
            Vector2 closestToCenter = v3;
            this.setRegionStart(region, closestToCenter, tileData);
            return true;
        }
        if (!((Collection)dryTiles).isEmpty()) {
            Object e;
            void $this$maxByOrNull$iv;
            center = dryTiles;
            HashSet<Vector2> hashSet = fallbackTiles;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                e = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    e = maxElem$iv;
                } else {
                    it = (Vector2)maxElem$iv;
                    boolean bl5 = false;
                    Object object = tileData.get(it);
                    Intrinsics.checkNotNull(object);
                    int maxValue$iv = ((MapGenTileData)object).getStartScore();
                    do {
                        Object e$iv = iterator$iv.next();
                        Vector2 it5 = (Vector2)e$iv;
                        $i$a$-maxByOrNull-RegionStartFinder$findEdgePosition$2 = false;
                        Object object2 = tileData.get((Object)it5);
                        Intrinsics.checkNotNull(object2);
                        int v$iv = ((MapGenTileData)object2).getStartScore();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    e = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(e);
            hashSet.add((Vector2)e);
        }
        return false;
    }

    private final void findFallbackPosition(HashSet<Vector2> fallbackTiles, TileDataMap tileData, Region region) {
        Object element$iv2;
        Vector2 panicPosition;
        block7: {
            Object v0;
            Iterable $this$maxByOrNull$iv = fallbackTiles;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Vector2 it = (Vector2)maxElem$iv;
                    boolean bl = false;
                    Object object = tileData.get((Object)it);
                    Intrinsics.checkNotNull(object);
                    int maxValue$iv = ((MapGenTileData)object).getStartScore();
                    do {
                        Object e$iv = iterator$iv.next();
                        Vector2 it2 = (Vector2)e$iv;
                        $i$a$-maxByOrNull-RegionStartFinder$findFallbackPosition$fallbackPosition$1 = false;
                        Object object2 = tileData.get((Object)it2);
                        Intrinsics.checkNotNull(object2);
                        int v$iv = ((MapGenTileData)object2).getStartScore();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Vector2 fallbackPosition = v0;
            if (fallbackPosition != null) {
                this.setRegionStart(region, fallbackPosition, tileData);
                return;
            }
            panicPosition = region.getRect().getPosition(new Vector2());
            Ruleset ruleset = region.getTileMap().getRuleset();
            Intrinsics.checkNotNull(ruleset);
            Collection<Terrain> collection = ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$first$iv = collection;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Terrain it = (Terrain)element$iv2;
                boolean bl = false;
                if (!(it.getType() == TerrainType.Land)) continue;
                break block7;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String panicTerrain = ((Terrain)element$iv2).getName();
        TileMap tileMap = region.getTileMap();
        Intrinsics.checkNotNull(panicPosition);
        tileMap.get(panicPosition).setBaseTerrain(panicTerrain);
        region.getTileMap().get(panicPosition).setTerrainFeatures(CollectionsKt.emptyList());
        this.setRegionStart(region, panicPosition, tileData);
    }

    @Pure
    private final Rectangle getCentralRectangle(Rectangle originalRect, float proportion) {
        Rectangle scaledRect = new Rectangle(originalRect);
        scaledRect.width = originalRect.width * proportion;
        scaledRect.height = originalRect.height * proportion;
        scaledRect.x = originalRect.x + (originalRect.width - scaledRect.width) / (float)2;
        scaledRect.y = originalRect.y + (originalRect.height - scaledRect.height) / (float)2;
        scaledRect.x = MathKt.roundToInt(scaledRect.x);
        scaledRect.y = MathKt.roundToInt(scaledRect.y);
        scaledRect.width = MathKt.roundToInt(scaledRect.width);
        scaledRect.height = MathKt.roundToInt(scaledRect.height);
        return scaledRect;
    }

    private final void evaluateTileForStart(Tile tile, TileDataMap tileData) {
        Object object = tileData.get((Object)tile.getPosition());
        Intrinsics.checkNotNull(object);
        MapGenTileData localData = (MapGenTileData)object;
        int totalFood = 0;
        int totalProd = 0;
        int totalGood = 0;
        int totalJunk = 0;
        int totalRivers = 0;
        int totalScore = 0;
        if (tile.isCoastalTile()) {
            totalScore += 40;
        }
        block4: for (int ring = 1; ring < 4; ++ring) {
            block17: {
                block16: {
                    Iterator<Tile> iterator2 = tile.getTilesAtDistance(ring).iterator();
                    while (iterator2.hasNext()) {
                        Tile outerTile = iterator2.next();
                        Object object2 = tileData.get((Object)outerTile.getPosition());
                        Intrinsics.checkNotNull(object2);
                        MapGenTileData outerTileData = (MapGenTileData)object2;
                        if (outerTileData.isJunk()) {
                            ++totalJunk;
                            continue;
                        }
                        if (outerTileData.isFood()) {
                            ++totalFood;
                        }
                        if (outerTileData.isProd()) {
                            ++totalProd;
                        }
                        if (outerTileData.isGood()) {
                            ++totalGood;
                        }
                        if (!outerTile.isAdjacentToRiver()) continue;
                        ++totalRivers;
                    }
                    Integer n = MapRegions.Companion.getMinimumFoodForRing().get(ring);
                    Intrinsics.checkNotNull(n);
                    if (totalFood < ((Number)n).intValue()) break block16;
                    Integer n2 = MapRegions.Companion.getMinimumProdForRing().get(ring);
                    Intrinsics.checkNotNull(n2);
                    if (totalProd < ((Number)n2).intValue()) break block16;
                    Integer n3 = MapRegions.Companion.getMinimumGoodForRing().get(ring);
                    Intrinsics.checkNotNull(n3);
                    if (totalGood >= ((Number)n3).intValue()) break block17;
                }
                localData.setGoodStart(false);
            }
            switch (ring) {
                case 1: {
                    int foodScore = ((Number)MapRegions.Companion.getFirstRingFoodScores().get(totalFood)).intValue();
                    int prodScore = ((Number)MapRegions.Companion.getFirstRingProdScores().get(totalProd)).intValue();
                    totalScore += foodScore + prodScore + totalRivers + totalGood * 2 - totalJunk * 3;
                    continue block4;
                }
                case 2: {
                    int foodScore = totalFood > 10 ? ((Number)CollectionsKt.last(MapRegions.Companion.getSecondRingFoodScores())).intValue() : ((Number)MapRegions.Companion.getSecondRingFoodScores().get(totalFood)).intValue();
                    int effectiveTotalProd = totalProd >= totalFood * 2 ? totalProd : (totalFood + 1) / 2;
                    int prodScore = effectiveTotalProd > 5 ? ((Number)CollectionsKt.last(MapRegions.Companion.getSecondRingProdScores())).intValue() : ((Number)MapRegions.Companion.getSecondRingProdScores().get(effectiveTotalProd)).intValue();
                    totalScore += foodScore + prodScore + totalRivers + totalGood * 2 - totalJunk * 3;
                    continue block4;
                }
                default: {
                    totalScore += totalFood + totalProd + totalGood + totalRivers - totalJunk * 2;
                }
            }
        }
        if (totalJunk > 9) {
            localData.setGoodStart(false);
        }
        if (localData.getCloseStartPenalty() > 0) {
            localData.setGoodStart(false);
            totalScore -= totalScore * localData.getCloseStartPenalty() / 100;
        }
        localData.setStartScore(totalScore);
    }

    private final void setRegionStart(Region region, Vector2 position, TileDataMap tileData) {
        region.setStartPosition(position);
        for (Map.Entry<Integer, Integer> entry : MapRegions.Companion.getCloseStartPenaltyForRing().entrySet()) {
            int ring = ((Number)entry.getKey()).intValue();
            int penalty = ((Number)entry.getValue()).intValue();
            Iterator<Vector2> iterator2 = SequencesKt.map(region.getTileMap().get(position).getTilesAtDistance(ring), RegionStartFinder::setRegionStart$lambda$12).iterator();
            while (iterator2.hasNext()) {
                Vector2 outerTile = iterator2.next();
                Object object = tileData.get((Object)outerTile);
                Intrinsics.checkNotNull(object);
                ((MapGenTileData)object).addCloseStartPenalty(penalty);
            }
        }
    }

    private static final boolean findStart$lambda$0(Sequence $centerTiles, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SequencesKt.contains($centerTiles, it);
    }

    private static final boolean findStart$lambda$1(Sequence $centerTiles, Sequence $middleDonut, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SequencesKt.contains($centerTiles, it) || SequencesKt.contains($middleDonut, it);
    }

    private static final Vector2 setRegionStart$lambda$12(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition();
    }
}

