/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DeclareWar;", "", "<init>", "()V", "declareWar", "", "diplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "declareWarReason", "Lcom/unciv/logic/civilization/diplomacy/DeclareWarReason;", "declareWar$core", "triggerUniques", "otherCiv", "Lcom/unciv/logic/civilization/Civilization;", "warDeclarerCiv", "handleCityStateDirectAttack", "notifyOfWar", "onWarDeclared", "isOffensiveWar", "", "warType", "Lcom/unciv/logic/civilization/diplomacy/WarType;", "changeOpinions", "breakTreaties", "removeDefensivePacts", "callInDefensivePactAllies", "callInCityStateAllies", "core"})
@SourceDebugExtension(value={"SMAP\nDeclareWar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclareWar.kt\ncom/unciv/logic/civilization/diplomacy/DeclareWar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,377:1\n1869#2,2:378\n827#2:380\n855#2,2:381\n1869#2,2:383\n827#2:385\n855#2,2:386\n1869#2,2:388\n774#2:390\n865#2,2:391\n295#2:393\n1761#2,3:394\n296#2:397\n295#2:398\n1761#2,3:399\n296#2:402\n774#2:403\n865#2,2:404\n*S KotlinDebug\n*F\n+ 1 DeclareWar.kt\ncom/unciv/logic/civilization/diplomacy/DeclareWar\n*L\n99#1:378,2\n117#1:380\n117#1:381,2\n117#1:383,2\n142#1:385\n142#1:386,2\n142#1:388,2\n154#1:390\n154#1:391,2\n297#1:393\n297#1:394,3\n297#1:397\n300#1:398\n300#1:399,3\n300#1:402\n326#1:403\n326#1:404,2\n*E\n"})
public final class DeclareWar {
    @NotNull
    public static final DeclareWar INSTANCE = new DeclareWar();

    private DeclareWar() {
    }

    public final void declareWar$core(@NotNull DiplomacyManager diplomacyManager, @NotNull DeclareWarReason declareWarReason) {
        Intrinsics.checkNotNullParameter(diplomacyManager, "diplomacyManager");
        Intrinsics.checkNotNullParameter(declareWarReason, "declareWarReason");
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        if (otherCiv.isCityState() && declareWarReason.getWarType() == WarType.DirectWar) {
            this.handleCityStateDirectAttack(diplomacyManager);
        }
        this.notifyOfWar(diplomacyManager, declareWarReason);
        this.onWarDeclared(diplomacyManager, true, declareWarReason.getWarType());
        this.onWarDeclared(otherCivDiplomacy, false, declareWarReason.getWarType());
        this.changeOpinions(diplomacyManager, declareWarReason);
        this.breakTreaties(diplomacyManager);
        this.triggerUniques(otherCiv, civInfo);
    }

    private final void triggerUniques(Civilization otherCiv, Civilization warDeclarerCiv) {
        if (otherCiv.isMajorCiv()) {
            for (Unique unique : Civilization.getTriggeredUniques$default(warDeclarerCiv, UniqueType.TriggerUponDeclaringWar, null, null, 6, null)) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, warDeclarerCiv, null, null, null, null, null, 124, null);
            }
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(warDeclarerCiv, UniqueType.TriggerUponDeclaringWarFiltered, null, arg_0 -> DeclareWar.triggerUniques$lambda$0(otherCiv, arg_0), 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, warDeclarerCiv, null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(otherCiv, UniqueType.TriggerUponBeingDeclaredWarUpon, null, arg_0 -> DeclareWar.triggerUniques$lambda$1(warDeclarerCiv, arg_0), 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, otherCiv, null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(warDeclarerCiv, UniqueType.TriggerUponEnteringWar, null, arg_0 -> DeclareWar.triggerUniques$lambda$2(otherCiv, arg_0), 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, warDeclarerCiv, null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(otherCiv, UniqueType.TriggerUponEnteringWar, null, arg_0 -> DeclareWar.triggerUniques$lambda$3(warDeclarerCiv, arg_0), 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, otherCiv, null, null, null, null, null, 124, null);
        }
    }

    private final void handleCityStateDirectAttack(DiplomacyManager diplomacyManager) {
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        otherCivDiplomacy.setInfluence(-60.0f);
        civInfo.setNumMinorCivsAttacked$core(civInfo.getNumMinorCivsAttacked$core() + 1);
        otherCiv.getCityStateFunctions().cityStateAttacked(civInfo);
        if (Intrinsics.areEqual(otherCiv.getAllyCivName(), civInfo.getCivName())) {
            otherCiv.getCityStateFunctions().updateAllyCivForCityState();
            otherCivDiplomacy.setInfluence(-120.0f);
            Iterator<Civilization> iterator2 = civInfo.getKnownCivs().iterator();
            while (iterator2.hasNext()) {
                Civilization knownCiv = iterator2.next();
                DiplomacyManager diplomacyManager2 = knownCiv.getDiplomacyManager(civInfo);
                Intrinsics.checkNotNull(diplomacyManager2);
                diplomacyManager2.addModifier(DiplomaticModifiers.BetrayedDeclarationOfFriendship, -10.0f);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyOfWar(DiplomacyManager diplomacyManager, DeclareWarReason declareWarReason) {
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        switch (WhenMappings.$EnumSwitchMapping$0[declareWarReason.getWarType().ordinal()]) {
            case 1: {
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, civInfo.getCivName()));
                String[] stringArray = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", civInfo.getCivName()};
                otherCiv.addNotification('[' + civInfo.getCivName() + "] has declared war on us!", Notification.NotificationCategory.Diplomacy, stringArray);
                Iterable $this$forEach$iv = diplomacyManager.getCommonKnownCivsWithSpectators();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    String[] stringArray2 = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", civInfo.getCivName()};
                    it.addNotification('[' + civInfo.getCivName() + "] has declared war on [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray2);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                String[] $this$forEach$iv2;
                Object element$iv$iv;
                Iterator $this$filterNotTo$iv$iv;
                Civilization civilization = declareWarReason.getAllyCiv();
                Intrinsics.checkNotNull(civilization);
                Civilization allyCiv = civilization;
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, civInfo.getCivName()));
                Civilization aggressor = declareWarReason.getWarType() == WarType.DefensivePactWar ? otherCiv : civInfo;
                Civilization defender = declareWarReason.getWarType() == WarType.DefensivePactWar ? civInfo : otherCiv;
                String[] element$iv = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), aggressor.getCivName()};
                defender.addNotification('[' + aggressor.getCivName() + "] has joined [" + allyCiv.getCivName() + "] in the war against us!", Notification.NotificationCategory.Diplomacy, element$iv);
                element$iv = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), aggressor.getCivName()};
                aggressor.addNotification("We have joined [" + allyCiv.getCivName() + "] in the war against [" + defender.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, element$iv);
                Iterable $this$filterNot$iv = diplomacyManager.getCommonKnownCivsWithSpectators();
                boolean $i$f$filterNot = false;
                Iterable bl = $this$filterNot$iv;
                Collection collection = new ArrayList();
                boolean $i$f$filterNotTo = false;
                Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(it, allyCiv)) continue;
                    collection.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)collection;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv2) {
                    Civilization it = (Civilization)t;
                    boolean bl3 = false;
                    element$iv$iv = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), aggressor.getCivName()};
                    it.addNotification('[' + aggressor.getCivName() + "] has joined [" + allyCiv.getCivName() + "] in the war against [" + defender.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, (String)element$iv$iv);
                }
                $this$forEach$iv2 = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), aggressor.getCivName()};
                allyCiv.addNotification('[' + aggressor.getCivName() + "] has joined us in the war against [" + defender.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, $this$forEach$iv2);
                break;
            }
            case 7: {
                void $this$forEach$iv;
                void $this$filterNotTo$iv$iv;
                Civilization civilization = declareWarReason.getAllyCiv();
                Intrinsics.checkNotNull(civilization);
                Civilization allyCiv = civilization;
                if (civInfo.getGameInfo().getCivilizations().indexOf(civInfo) > civInfo.getGameInfo().getCivilizations().indexOf(allyCiv)) {
                    return;
                }
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, civInfo.getCivName()));
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, allyCiv.getCivName()));
                String[] aggressor = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), civInfo.getCivName()};
                civInfo.addNotification("You and [" + allyCiv.getCivName() + "] have declared war against [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, aggressor);
                aggressor = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", civInfo.getCivName(), allyCiv.getCivName()};
                allyCiv.addNotification("You and [" + civInfo.getCivName() + "] have declared war against [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, aggressor);
                aggressor = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), civInfo.getCivName()};
                otherCiv.addNotification('[' + civInfo.getCivName() + "] and [" + allyCiv.getCivName() + "] have declared war against us!", Notification.NotificationCategory.Diplomacy, aggressor);
                Iterable $this$filterNot$iv = diplomacyManager.getCommonKnownCivsWithSpectators();
                boolean $i$f$filterNot = false;
                Iterable $this$forEach$iv2 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, allyCiv)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    String[] stringArray = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), civInfo.getCivName()};
                    it.addNotification('[' + civInfo.getCivName() + "] and [" + allyCiv.getCivName() + "] have declared war against [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onWarDeclared(DiplomacyManager diplomacyManager, boolean isOffensiveWar, WarType warType) {
        Iterator<Trade> iterator2 = diplomacyManager.getTrades().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Trade> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            void $this$filterTo$iv$iv;
            Trade trade;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Iterable $this$filter$iv = trade.getTheirOffers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getDuration() > 0 && !Intrinsics.areEqual(it.getName(), "Defensive Pact"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                TradeOffer offer = (TradeOffer)e;
                String[] stringArray = new String[]{diplomacyManager.getOtherCivName(), "StatIcons/Acquire"};
                diplomacyManager.getCivInfo().addNotification('[' + offer.getName() + "] from [" + diplomacyManager.getOtherCivName() + "] has ended", new DiplomacyAction(diplomacyManager.getOtherCivName(), true), Notification.NotificationCategory.Trade, stringArray);
            }
        }
        diplomacyManager.getTrades().clear();
        CollectionsKt.removeAll((List)diplomacyManager.getCivInfo().getTradeRequests(), arg_0 -> DeclareWar.onWarDeclared$lambda$10(diplomacyManager, arg_0));
        diplomacyManager.updateHasOpenBorders();
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        if (isOffensiveWar) {
            this.removeDefensivePacts(diplomacyManager);
        }
        diplomacyManager.setDiplomaticStatus(DiplomaticStatus.War);
        if (diplomacyManager.getCivInfo().isMajorCiv()) {
            if (!isOffensiveWar && warType != WarType.DefensivePactWar && !civAtWarWith.isCityState()) {
                this.callInDefensivePactAllies(diplomacyManager);
            }
            this.callInCityStateAllies(diplomacyManager);
        }
        if (diplomacyManager.getCivInfo().isCityState() && diplomacyManager.getCivInfo().getCityStateFunctions().getProtectorCivs().contains(civAtWarWith)) {
            diplomacyManager.getCivInfo().getCityStateFunctions().removeProtectorCiv(civAtWarWith, true);
        }
        diplomacyManager.removeModifier$core(DiplomaticModifiers.YearsOfPeace);
        diplomacyManager.setFlag(DiplomacyFlags.DeclinedPeace, diplomacyManager.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMinimumWarDuration());
        diplomacyManager.setFlag(DiplomacyFlags.DeclaredWar, diplomacyManager.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMinimumWarDuration());
        diplomacyManager.removeFlag(DiplomacyFlags.BorderConflict);
        diplomacyManager.getCivInfo().getDiplomacyFunctions().removeEmbassies(civAtWarWith);
    }

    private final void changeOpinions(DiplomacyManager diplomacyManager, DeclareWarReason declareWarReason) {
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        WarType warType = declareWarReason.getWarType();
        otherCivDiplomacy.setModifier(DiplomaticModifiers.DeclaredWarOnUs, -20.0f);
        otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.ReturnedCapturedUnits);
        if (warType == WarType.DirectWar || warType == WarType.JoinWar || warType == WarType.TeamWar) {
            Iterator<Civilization> iterator2 = civInfo.getKnownCivs().iterator();
            while (iterator2.hasNext()) {
                Civilization thirdCiv = iterator2.next();
                if (thirdCiv.isAtWarWith(otherCiv)) continue;
                DiplomacyManager diplomacyManager2 = thirdCiv.getDiplomacyManager(otherCiv);
                if ((diplomacyManager2 != null ? !diplomacyManager2.isRelationshipLevelGT(RelationshipLevel.Competitor) : false) || Intrinsics.areEqual(thirdCiv, declareWarReason.getAllyCiv())) continue;
                DiplomacyManager diplomacyManager3 = thirdCiv.getDiplomacyManager(civInfo);
                Intrinsics.checkNotNull(diplomacyManager3);
                diplomacyManager3.addModifier(DiplomaticModifiers.WarMongerer, -5.0f);
            }
        }
        for (Civilization thirdCiv : diplomacyManager.getCommonKnownCivs()) {
            if ((thirdCiv.isAtWarWith(otherCiv) || Intrinsics.areEqual(thirdCiv, declareWarReason.getAllyCiv())) && !thirdCiv.isAtWarWith(civInfo)) {
                if (thirdCiv.isCityState()) {
                    DiplomacyManager diplomacyManager4 = thirdCiv.getDiplomacyManager(civInfo);
                    Intrinsics.checkNotNull(diplomacyManager4);
                    diplomacyManager4.addInfluence(10.0f);
                    continue;
                }
                DiplomacyManager diplomacyManager5 = thirdCiv.getDiplomacyManager(civInfo);
                Intrinsics.checkNotNull(diplomacyManager5);
                diplomacyManager5.addModifier(DiplomaticModifiers.SharedEnemy, 5.0f * civInfo.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
                continue;
            }
            if (!thirdCiv.isAtWarWith(civInfo)) continue;
            if (thirdCiv.isCityState()) {
                DiplomacyManager diplomacyManager6 = thirdCiv.getDiplomacyManager(otherCiv);
                Intrinsics.checkNotNull(diplomacyManager6);
                diplomacyManager6.addInfluence(10.0f);
                continue;
            }
            DiplomacyManager diplomacyManager7 = thirdCiv.getDiplomacyManager(otherCiv);
            Intrinsics.checkNotNull(diplomacyManager7);
            diplomacyManager7.addModifier(DiplomaticModifiers.SharedEnemy, 5.0f * civInfo.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
        }
    }

    private final void breakTreaties(DiplomacyManager diplomacyManager) {
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        boolean betrayedFriendship = false;
        boolean betrayedDefensivePact = false;
        if (diplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
            betrayedFriendship = true;
            diplomacyManager.removeFlag(DiplomacyFlags.DeclarationOfFriendship);
            otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.DeclarationOfFriendship);
        }
        otherCivDiplomacy.removeFlag(DiplomacyFlags.DeclarationOfFriendship);
        if (diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact)) {
            betrayedDefensivePact = true;
            diplomacyManager.removeFlag(DiplomacyFlags.DefensivePact);
            otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.DefensivePact);
        }
        otherCivDiplomacy.removeFlag(DiplomacyFlags.DefensivePact);
        if (betrayedFriendship || betrayedDefensivePact) {
            Iterator<Civilization> iterator2 = diplomacyManager.getCivInfo().getKnownCivs().iterator();
            while (iterator2.hasNext()) {
                DiplomacyManager diploManager;
                float amount;
                Civilization knownCiv = iterator2.next();
                Intrinsics.checkNotNull(knownCiv.getDiplomacyManager(diplomacyManager.getCivInfo()));
                if (betrayedFriendship) {
                    amount = Intrinsics.areEqual(knownCiv, otherCiv) ? -40.0f : -20.0f;
                    diploManager.addModifier(DiplomaticModifiers.BetrayedDeclarationOfFriendship, amount * knownCiv.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
                }
                if (betrayedDefensivePact) {
                    amount = Intrinsics.areEqual(knownCiv, otherCiv) ? -20.0f : -10.0f;
                    diploManager.addModifier(DiplomaticModifiers.BetrayedDefensivePact, amount * knownCiv.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
                }
                diploManager.removeModifier$core(DiplomaticModifiers.DeclaredFriendshipWithOurAllies);
                diploManager.removeModifier$core(DiplomaticModifiers.SignedDefensivePactWithOurAllies);
            }
        }
        if (diplomacyManager.hasFlag(DiplomacyFlags.ResearchAgreement)) {
            diplomacyManager.removeFlag(DiplomacyFlags.ResearchAgreement);
            diplomacyManager.setTotalOfScienceDuringRA$core(0);
            otherCivDiplomacy.setTotalOfScienceDuringRA$core(0);
        }
        otherCivDiplomacy.removeFlag(DiplomacyFlags.ResearchAgreement);
        otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.GaveUsGifts);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeDefensivePacts(DiplomacyManager diplomacyManager) {
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        Iterator<DiplomacyManager> iterator2 = diplomacyManager.getCivInfo().getDiplomacy().values().iterator();
        while (iterator2.hasNext()) {
            DiplomacyManager thirdPartyDiploManager;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (thirdPartyDiploManager.getDiplomaticStatus() != DiplomaticStatus.DefensivePact) continue;
            thirdPartyDiploManager.setDiplomaticStatus(DiplomaticStatus.Peace);
            thirdPartyDiploManager.otherCivDiplomacy().setDiplomaticStatus(DiplomaticStatus.Peace);
            if (!Intrinsics.areEqual(thirdPartyDiploManager.otherCiv(), civAtWarWith)) {
                Object v3;
                block14: {
                    void $this$firstOrNull$iv;
                    Object v1;
                    block12: {
                        void $this$firstOrNull$iv2;
                        Iterable iterable = thirdPartyDiploManager.getTrades();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv2) {
                            boolean bl;
                            block11: {
                                Trade trade = (Trade)element$iv;
                                boolean bl2 = false;
                                Iterable $this$any$iv = trade.getOurOffers();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        TradeOffer offer = (TradeOffer)element$iv2;
                                        boolean bl3 = false;
                                        if (!Intrinsics.areEqual(offer.getName(), "Defensive Pact")) continue;
                                        bl = true;
                                        break block11;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) continue;
                            v1 = element$iv;
                            break block12;
                        }
                        v1 = null;
                    }
                    Trade defensivePactOffer = v1;
                    TypeIntrinsics.asMutableCollection(thirdPartyDiploManager.getTrades()).remove(defensivePactOffer);
                    Iterable $i$f$firstOrNull = thirdPartyDiploManager.otherCivDiplomacy().getTrades();
                    boolean $i$f$firstOrNull2 = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        block13: {
                            Trade trade = (Trade)element$iv;
                            boolean bl4 = false;
                            Iterable $this$any$iv = trade.getOurOffers();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv3 : $this$any$iv) {
                                    TradeOffer offer = (TradeOffer)element$iv3;
                                    boolean bl5 = false;
                                    if (!Intrinsics.areEqual(offer.getName(), "Defensive Pact")) continue;
                                    bl = true;
                                    break block13;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        v3 = element$iv;
                        break block14;
                    }
                    v3 = null;
                }
                Trade theirDefensivePactOffer = v3;
                TypeIntrinsics.asMutableCollection(thirdPartyDiploManager.otherCivDiplomacy().getTrades()).remove(theirDefensivePactOffer);
                thirdPartyDiploManager.removeFlag(DiplomacyFlags.DefensivePact);
                thirdPartyDiploManager.otherCivDiplomacy().removeFlag(DiplomacyFlags.DefensivePact);
            }
            for (Civilization civ : thirdPartyDiploManager.getCommonKnownCivsWithSpectators()) {
                String[] stringArray = new String[]{diplomacyManager.getCivInfo().getCivName(), "OtherIcons/Diplomacy", thirdPartyDiploManager.getOtherCivName()};
                civ.addNotification('[' + diplomacyManager.getCivInfo().getCivName() + "] cancelled their Defensive Pact with [" + thirdPartyDiploManager.getOtherCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
            }
            String[] stringArray = new String[]{diplomacyManager.getCivInfo().getCivName(), "OtherIcons/Diplomacy", thirdPartyDiploManager.getOtherCivName()};
            thirdPartyDiploManager.otherCiv().addNotification('[' + diplomacyManager.getCivInfo().getCivName() + "] cancelled their Defensive Pact with us!", Notification.NotificationCategory.Diplomacy, stringArray);
            stringArray = new String[]{"OtherIcons/Diplomacy", thirdPartyDiploManager.getOtherCivName()};
            thirdPartyDiploManager.getCivInfo().addNotification("We have cancelled our Defensive Pact with [" + thirdPartyDiploManager.getOtherCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void callInDefensivePactAllies(DiplomacyManager diplomacyManager) {
        void $this$filterTo$iv$iv;
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        Collection<DiplomacyManager> collection = diplomacyManager.getCivInfo().getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiplomacyManager ourDipManager = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!(ourDipManager.getDiplomaticStatus() == DiplomaticStatus.DefensivePact && !ourDipManager.otherCiv().isDefeated() && !ourDipManager.otherCiv().isAtWarWith(civAtWarWith))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object e : (List)destination$iv$iv) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            DiplomacyManager ourDefensivePact = (DiplomacyManager)e;
            Civilization ally = ourDefensivePact.otherCiv();
            if (!civAtWarWith.knows(ally)) {
                civAtWarWith.getDiplomacyFunctions().makeCivilizationsMeet(ally, true);
            }
            DiplomacyManager diplomacyManager2 = civAtWarWith.getDiplomacyManager(ally);
            Intrinsics.checkNotNull(diplomacyManager2);
            diplomacyManager2.declareWar(new DeclareWarReason(WarType.DefensivePactWar, diplomacyManager.getCivInfo()));
        }
    }

    private final void callInCityStateAllies(DiplomacyManager diplomacyManager) {
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        Iterator<Civilization> iterator2 = SequencesKt.filter(diplomacyManager.getCivInfo().getKnownCivs(), arg_0 -> DeclareWar.callInCityStateAllies$lambda$16(diplomacyManager, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            if (thirdCiv.isAtWarWith(civAtWarWith)) continue;
            if (!thirdCiv.knows(civAtWarWith)) {
                thirdCiv.getDiplomacyFunctions().makeCivilizationsMeet(civAtWarWith, true);
            }
            DiplomacyManager diplomacyManager2 = thirdCiv.getDiplomacyManager(civAtWarWith);
            Intrinsics.checkNotNull(diplomacyManager2);
            diplomacyManager2.declareWar(new DeclareWarReason(WarType.CityStateAllianceWar, diplomacyManager.getCivInfo()));
        }
    }

    private static final boolean triggerUniques$lambda$0(Civilization $otherCiv, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Civilization.matchesFilter$default($otherCiv, it.getParams().get(0), null, false, 6, null);
    }

    private static final boolean triggerUniques$lambda$1(Civilization $warDeclarerCiv, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Civilization.matchesFilter$default($warDeclarerCiv, it.getParams().get(0), null, false, 6, null);
    }

    private static final boolean triggerUniques$lambda$2(Civilization $otherCiv, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Civilization.matchesFilter$default($otherCiv, it.getParams().get(0), null, false, 6, null);
    }

    private static final boolean triggerUniques$lambda$3(Civilization $warDeclarerCiv, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Civilization.matchesFilter$default($warDeclarerCiv, it.getParams().get(0), null, false, 6, null);
    }

    private static final boolean onWarDeclared$lambda$10(DiplomacyManager $diplomacyManager, TradeRequest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getRequestingCiv(), $diplomacyManager.getOtherCivName());
    }

    private static final boolean callInCityStateAllies$lambda$16(DiplomacyManager $diplomacyManager, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isCityState() && Intrinsics.areEqual(it.getAllyCivName(), $diplomacyManager.getCivInfo().getCivName());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WarType.values().length];
            try {
                nArray[WarType.DirectWar.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.DefensivePactWar.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.CityStateAllianceWar.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.JoinWar.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.ProtectedCityStateWar.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.AlliedCityStateWar.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.TeamWar.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

