/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Date;

final class CertificateBuilderCertGenerator {
    private CertificateBuilderCertGenerator() {
    }

    static boolean isAvailable() {
        try {
            new CertificateBuilder();
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    static void generate(SelfSignedCertificate.Builder config2) throws Exception {
        String fqdn = config2.fqdn;
        Date notBefore = config2.notBefore;
        Date notAfter = config2.notAfter;
        String algorithm = config2.algorithm;
        SecureRandom random = config2.random;
        int bits = config2.bits;
        CertificateBuilder builder2 = new CertificateBuilder();
        builder2.setIsCertificateAuthority(true);
        if (fqdn.contains("=")) {
            builder2.subject(fqdn);
        } else {
            builder2.subject("CN=" + fqdn);
        }
        builder2.notBefore(Instant.ofEpochMilli(notBefore.getTime()));
        builder2.notAfter(Instant.ofEpochMilli(notAfter.getTime()));
        if (random != null) {
            builder2.secureRandom(random);
        }
        if ("RSA".equals(algorithm)) {
            CertificateBuilder.Algorithm alg;
            switch (bits) {
                case 2048: {
                    alg = CertificateBuilder.Algorithm.rsa2048;
                    break;
                }
                case 3072: {
                    alg = CertificateBuilder.Algorithm.rsa3072;
                    break;
                }
                case 4096: {
                    alg = CertificateBuilder.Algorithm.rsa4096;
                    break;
                }
                case 8192: {
                    alg = CertificateBuilder.Algorithm.rsa8192;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported RSA bit-width: " + bits);
                }
            }
            builder2.algorithm(alg);
        } else if ("EC".equals(algorithm)) {
            if (bits == 256) {
                builder2.algorithm(CertificateBuilder.Algorithm.ecp256);
            } else if (bits == 384) {
                builder2.algorithm(CertificateBuilder.Algorithm.ecp384);
            } else {
                throw new IllegalArgumentException("Unsupported EC-P bit-width: " + bits);
            }
        }
        X509Bundle bundle = builder2.buildSelfSigned();
        config2.paths = SelfSignedCertificate.newSelfSignedCertificate(fqdn, bundle.getKeyPair().getPrivate(), bundle.getCertificate());
        config2.keypair = bundle.getKeyPair();
        config2.privateKey = bundle.getKeyPair().getPrivate();
    }
}

