/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.util.CryptoKt;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00019BZ\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012B\\\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\n\u0012\u0006\u0010\u0014\u001a\u00020\n\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001dJ'\u0010\"\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b%\u0010&R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010'\u001a\u0004\b*\u0010)R2\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\u000e\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010.\u001a\u0004\b1\u00100R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0011\u00108\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006:"}, d2={"Lio/ktor/server/sessions/SessionTransportTransformerEncrypt;", "Lio/ktor/server/sessions/SessionTransportTransformer;", "Ljavax/crypto/spec/SecretKeySpec;", "encryptionKeySpec", "signKeySpec", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "size", "", "ivGenerator", "", "encryptAlgorithm", "signAlgorithm", "", "backwardCompatibleRead", "<init>", "(Ljavax/crypto/spec/SecretKeySpec;Ljavax/crypto/spec/SecretKeySpec;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;Z)V", "encryptionKey", "signKey", "([B[BLkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;Z)V", "transportValue", "transformRead", "(Ljava/lang/String;)Ljava/lang/String;", "transformWrite", "initVector", "decrypted", "encrypt", "([B[B)[B", "encrypted", "decrypt", "mode", "input", "encryptDecrypt", "(I[B[B)[B", "value", "mac", "([B)[B", "Ljavax/crypto/spec/SecretKeySpec;", "getEncryptionKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "getSignKeySpec", "Lkotlin/jvm/functions/Function1;", "getIvGenerator", "()Lkotlin/jvm/functions/Function1;", "Ljava/lang/String;", "getEncryptAlgorithm", "()Ljava/lang/String;", "getSignAlgorithm", "Z", "Ljava/nio/charset/Charset;", "charset", "Ljava/nio/charset/Charset;", "getEncryptionKeySize", "()I", "encryptionKeySize", "Companion", "ktor-server-sessions"})
@SourceDebugExtension(value={"SMAP\nSessionTransportTransformerEncrypt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionTransportTransformerEncrypt.kt\nio/ktor/server/sessions/SessionTransportTransformerEncrypt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class SessionTransportTransformerEncrypt
implements SessionTransportTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeySpec encryptionKeySpec;
    @NotNull
    private final SecretKeySpec signKeySpec;
    @NotNull
    private final Function1<Integer, byte[]> ivGenerator;
    @NotNull
    private final String encryptAlgorithm;
    @NotNull
    private final String signAlgorithm;
    private final boolean backwardCompatibleRead;
    @NotNull
    private final Charset charset;
    private static final Logger log = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(SessionTransportTransformerEncrypt.class).getQualifiedName());

    public SessionTransportTransformerEncrypt(@NotNull SecretKeySpec encryptionKeySpec, @NotNull SecretKeySpec signKeySpec, @NotNull Function1<? super Integer, byte[]> ivGenerator, @NotNull String encryptAlgorithm, @NotNull String signAlgorithm, boolean backwardCompatibleRead) {
        Intrinsics.checkNotNullParameter(encryptionKeySpec, "encryptionKeySpec");
        Intrinsics.checkNotNullParameter(signKeySpec, "signKeySpec");
        Intrinsics.checkNotNullParameter(ivGenerator, "ivGenerator");
        Intrinsics.checkNotNullParameter(encryptAlgorithm, "encryptAlgorithm");
        Intrinsics.checkNotNullParameter(signAlgorithm, "signAlgorithm");
        this.encryptionKeySpec = encryptionKeySpec;
        this.signKeySpec = signKeySpec;
        this.ivGenerator = ivGenerator;
        this.encryptAlgorithm = encryptAlgorithm;
        this.signAlgorithm = signAlgorithm;
        this.backwardCompatibleRead = backwardCompatibleRead;
        this.charset = Charsets.UTF_8;
        this.encrypt(this.ivGenerator.invoke(this.getEncryptionKeySize()), new byte[0]);
        this.mac(new byte[0]);
    }

    public /* synthetic */ SessionTransportTransformerEncrypt(SecretKeySpec secretKeySpec, SecretKeySpec secretKeySpec2, Function1 function1, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = SessionTransportTransformerEncrypt::_init_$lambda$1;
        }
        if ((n & 8) != 0) {
            string = secretKeySpec.getAlgorithm();
        }
        if ((n & 0x10) != 0) {
            string2 = secretKeySpec2.getAlgorithm();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(secretKeySpec, secretKeySpec2, function1, string, string2, bl);
    }

    @NotNull
    public final SecretKeySpec getEncryptionKeySpec() {
        return this.encryptionKeySpec;
    }

    @NotNull
    public final SecretKeySpec getSignKeySpec() {
        return this.signKeySpec;
    }

    @NotNull
    public final Function1<Integer, byte[]> getIvGenerator() {
        return this.ivGenerator;
    }

    @NotNull
    public final String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    @NotNull
    public final String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public final int getEncryptionKeySize() {
        return this.encryptionKeySpec.getEncoded().length;
    }

    public SessionTransportTransformerEncrypt(@NotNull byte[] encryptionKey, @NotNull byte[] signKey, @NotNull Function1<? super Integer, byte[]> ivGenerator, @NotNull String encryptAlgorithm, @NotNull String signAlgorithm, boolean backwardCompatibleRead) {
        Intrinsics.checkNotNullParameter(encryptionKey, "encryptionKey");
        Intrinsics.checkNotNullParameter(signKey, "signKey");
        Intrinsics.checkNotNullParameter(ivGenerator, "ivGenerator");
        Intrinsics.checkNotNullParameter(encryptAlgorithm, "encryptAlgorithm");
        Intrinsics.checkNotNullParameter(signAlgorithm, "signAlgorithm");
        this(new SecretKeySpec(encryptionKey, encryptAlgorithm), new SecretKeySpec(signKey, signAlgorithm), ivGenerator, null, null, backwardCompatibleRead, 24, null);
    }

    public /* synthetic */ SessionTransportTransformerEncrypt(byte[] byArray, byte[] byArray2, Function1 function1, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = SessionTransportTransformerEncrypt::_init_$lambda$3;
        }
        if ((n & 8) != 0) {
            string = "AES";
        }
        if ((n & 0x10) != 0) {
            string2 = "HmacSHA256";
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(byArray, byArray2, function1, string, string2, bl);
    }

    @Override
    @Nullable
    public String transformRead(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        try {
            String encryptedAndMac = StringsKt.substringAfterLast(transportValue, '/', "");
            String macHex = StringsKt.substringAfterLast(encryptedAndMac, ':', "");
            byte[] encrypted = CryptoKt.hex(StringsKt.substringBeforeLast$default(encryptedAndMac, ':', null, 2, null));
            boolean macCheck = Intrinsics.areEqual(CryptoKt.hex(this.mac(encrypted)), macHex);
            if (!macCheck && !this.backwardCompatibleRead) {
                return null;
            }
            byte[] iv = CryptoKt.hex(StringsKt.substringBeforeLast$default(transportValue, '/', null, 2, null));
            byte[] decrypted = this.decrypt(iv, encrypted);
            if (!macCheck && !Intrinsics.areEqual(CryptoKt.hex(this.mac(decrypted)), macHex)) {
                return null;
            }
            return new String(decrypted, this.charset);
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug(e.toString());
            }
            return null;
        }
    }

    @Override
    @NotNull
    public String transformWrite(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        byte[] iv = this.ivGenerator.invoke(this.getEncryptionKeySize());
        byte[] byArray = transportValue.getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] decrypted = byArray;
        byte[] encrypted = this.encrypt(iv, decrypted);
        byte[] mac = this.mac(encrypted);
        return CryptoKt.hex(iv) + '/' + CryptoKt.hex(encrypted) + ':' + CryptoKt.hex(mac);
    }

    private final byte[] encrypt(byte[] initVector, byte[] decrypted) {
        return this.encryptDecrypt(1, initVector, decrypted);
    }

    private final byte[] decrypt(byte[] initVector, byte[] encrypted) {
        return this.encryptDecrypt(2, initVector, encrypted);
    }

    private final byte[] encryptDecrypt(int mode, byte[] initVector, byte[] input) {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        Cipher cipher = Cipher.getInstance(this.encryptAlgorithm + "/CBC/PKCS5PADDING");
        cipher.init(mode, (Key)this.encryptionKeySpec, iv);
        byte[] byArray = cipher.doFinal(input);
        Intrinsics.checkNotNullExpressionValue(byArray, "doFinal(...)");
        return byArray;
    }

    private final byte[] mac(byte[] value) {
        Mac $this$mac_u24lambda_u244 = Mac.getInstance(this.signAlgorithm);
        boolean bl = false;
        $this$mac_u24lambda_u244.init(this.signKeySpec);
        byte[] byArray = $this$mac_u24lambda_u244.doFinal(value);
        Intrinsics.checkNotNullExpressionValue(byArray, "run(...)");
        return byArray;
    }

    private static final byte[] _init_$lambda$1(int size) {
        byte[] byArray;
        byte[] $this$_init__u24lambda_u241_u24lambda_u240 = byArray = new byte[size];
        boolean bl = false;
        new SecureRandom().nextBytes($this$_init__u24lambda_u241_u24lambda_u240);
        return byArray;
    }

    private static final byte[] _init_$lambda$3(int size) {
        byte[] byArray;
        byte[] $this$_init__u24lambda_u243_u24lambda_u242 = byArray = new byte[size];
        boolean bl = false;
        new SecureRandom().nextBytes($this$_init__u24lambda_u243_u24lambda_u242);
        return byArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/ktor/server/sessions/SessionTransportTransformerEncrypt$Companion;", "", "<init>", "()V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "ktor-server-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

