/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.sessions.CookieConfiguration;
import io.ktor.server.sessions.SessionTransport;
import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.server.sessions.SessionTransportTransformerKt;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0018\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lio/ktor/server/sessions/SessionTransportCookie;", "Lio/ktor/server/sessions/SessionTransport;", "", "name", "Lio/ktor/server/sessions/CookieConfiguration;", "configuration", "", "Lio/ktor/server/sessions/SessionTransportTransformer;", "transformers", "<init>", "(Ljava/lang/String;Lio/ktor/server/sessions/CookieConfiguration;Ljava/util/List;)V", "Lio/ktor/server/application/ApplicationCall;", "call", "receive", "(Lio/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "value", "", "send", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;)V", "clear", "(Lio/ktor/server/application/ApplicationCall;)V", "Lio/ktor/http/Cookie;", "clearCookie$ktor_server_sessions", "()Lio/ktor/http/Cookie;", "clearCookie", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getName", "Lio/ktor/server/sessions/CookieConfiguration;", "getConfiguration", "()Lio/ktor/server/sessions/CookieConfiguration;", "Ljava/util/List;", "getTransformers", "()Ljava/util/List;", "ktor-server-sessions"})
public final class SessionTransportCookie
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final CookieConfiguration configuration;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    public SessionTransportCookie(@NotNull String name, @NotNull CookieConfiguration configuration, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(transformers, "transformers");
        this.name = name;
        this.configuration = configuration;
        this.transformers = transformers;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CookieConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter(call, "call");
        return SessionTransportTransformerKt.transformRead(this.transformers, call.getRequest().getCookies().get(this.name, this.configuration.getEncoding()));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(value, "value");
        now = DateJvmKt.GMTDate$default(null, 1, null);
        var6_5 = maxAge = this.configuration.getMaxAgeInSeconds();
        if (var6_5 == null) ** GOTO lbl-1000
        var7_6 = 0L;
        if (var6_5 == var7_6) lbl-1000:
        // 2 sources

        {
            v0 = null;
        } else {
            v0 = DateKt.plus(now, maxAge * 1000L);
        }
        expires = v0;
        v1 = maxAge;
        cookie = new Cookie(this.name, SessionTransportTransformerKt.transformWrite(this.transformers, value), this.configuration.getEncoding(), v1 != null ? Integer.valueOf((int)RangesKt.coerceAtMost(v1, 0x7FFFFFFFL)) : null, expires, this.configuration.getDomain(), this.configuration.getPath(), this.configuration.getSecure(), this.configuration.getHttpOnly(), this.configuration.getExtensions());
        call.getResponse().getCookies().append(cookie);
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter(call, "call");
        call.getResponse().getCookies().append(this.clearCookie$ktor_server_sessions());
    }

    @NotNull
    public final Cookie clearCookie$ktor_server_sessions() {
        String string = this.name;
        CookieEncoding cookieEncoding = this.configuration.getEncoding();
        String string2 = this.configuration.getDomain();
        String string3 = this.configuration.getPath();
        boolean bl = this.configuration.getSecure();
        boolean bl2 = this.configuration.getHttpOnly();
        Map<String, String> map2 = this.configuration.getExtensions();
        GMTDate gMTDate = GMTDate.Companion.getSTART();
        return new Cookie(string, "", cookieEncoding, 0, gMTDate, string2, string3, bl, bl2, map2);
    }

    @NotNull
    public String toString() {
        return "SessionTransportCookie: " + this.name;
    }
}

