/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HttpStatusCode;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.PipelineResponse;
import io.ktor.server.response.ResponseCookies;
import io.ktor.server.response.ResponseHeaders;
import io.ktor.server.response.ResponsePushBuilder;
import io.ktor.server.response.UseHttp2Push;
import io.ktor.server.routing.RoutingCall;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\rJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lio/ktor/server/routing/RoutingResponse;", "Lio/ktor/server/response/ApplicationResponse;", "Lio/ktor/server/routing/RoutingCall;", "call", "Lio/ktor/server/response/PipelineResponse;", "applicationResponse", "<init>", "(Lio/ktor/server/routing/RoutingCall;Lio/ktor/server/response/PipelineResponse;)V", "Lio/ktor/http/HttpStatusCode;", "status", "()Lio/ktor/http/HttpStatusCode;", "value", "", "(Lio/ktor/http/HttpStatusCode;)V", "Lio/ktor/server/response/ResponsePushBuilder;", "builder", "push", "(Lio/ktor/server/response/ResponsePushBuilder;)V", "Lio/ktor/server/routing/RoutingCall;", "getCall", "()Lio/ktor/server/routing/RoutingCall;", "Lio/ktor/server/response/PipelineResponse;", "getApplicationResponse$ktor_server_core", "()Lio/ktor/server/response/PipelineResponse;", "", "isCommitted", "()Z", "isSent", "Lio/ktor/server/response/ResponseHeaders;", "headers", "Lio/ktor/server/response/ResponseHeaders;", "getHeaders", "()Lio/ktor/server/response/ResponseHeaders;", "Lio/ktor/server/response/ResponseCookies;", "cookies", "Lio/ktor/server/response/ResponseCookies;", "getCookies", "()Lio/ktor/server/response/ResponseCookies;", "ktor-server-core"})
public final class RoutingResponse
implements ApplicationResponse {
    @NotNull
    private final RoutingCall call;
    @NotNull
    private final PipelineResponse applicationResponse;
    @NotNull
    private final ResponseHeaders headers;
    @NotNull
    private final ResponseCookies cookies;

    public RoutingResponse(@NotNull RoutingCall call, @NotNull PipelineResponse applicationResponse) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(applicationResponse, "applicationResponse");
        this.call = call;
        this.applicationResponse = applicationResponse;
        this.headers = this.applicationResponse.getHeaders();
        this.cookies = this.applicationResponse.getCookies();
    }

    @Override
    @NotNull
    public RoutingCall getCall() {
        return this.call;
    }

    @NotNull
    public final PipelineResponse getApplicationResponse$ktor_server_core() {
        return this.applicationResponse;
    }

    @Override
    public boolean isCommitted() {
        return this.applicationResponse.isCommitted();
    }

    @Override
    public boolean isSent() {
        return this.applicationResponse.isSent();
    }

    @Override
    @NotNull
    public ResponseHeaders getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public ResponseCookies getCookies() {
        return this.cookies;
    }

    @Override
    @Nullable
    public HttpStatusCode status() {
        return this.applicationResponse.status();
    }

    @Override
    public void status(@NotNull HttpStatusCode value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.applicationResponse.status(value);
    }

    @Override
    @UseHttp2Push
    public void push(@NotNull ResponsePushBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        this.applicationResponse.push(builder2);
    }
}

