/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.FileChannelsAtNioPathKt;
import io.ktor.utils.io.ByteReadChannel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\t\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/http/content/LocalPathContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/nio/file/Path;", "path", "Lio/ktor/http/ContentType;", "contentType", "<init>", "(Ljava/nio/file/Path;Lio/ktor/http/ContentType;)V", "Lio/ktor/utils/io/ByteReadChannel;", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "Lkotlin/ranges/LongRange;", "range", "(Lkotlin/ranges/LongRange;)Lio/ktor/utils/io/ByteReadChannel;", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "ktor-server-core"})
public final class LocalPathContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final Path path;
    @NotNull
    private final ContentType contentType;

    public LocalPathContent(@NotNull Path path2, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(contentType, "contentType");
        this.path = path2;
        this.contentType = contentType;
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new IOException("No such path " + this.path);
        }
        FileTime lastModifiedVersion = Files.getLastModifiedTime(this.path, new LinkOption[0]);
        OutgoingContent outgoingContent = this;
        Collection collection = VersionsKt.getVersions(this);
        Intrinsics.checkNotNull(lastModifiedVersion);
        VersionsKt.setVersions(outgoingContent, CollectionsKt.plus(collection, LastModifiedJavaTimeKt.LastModifiedVersion(lastModifiedVersion)));
    }

    public /* synthetic */ LocalPathContent(Path path2, ContentType contentType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            contentType = FileContentTypeKt.defaultForFileExtension(ContentType.Companion, PathsKt.getExtension(path2));
        }
        this(path2, contentType);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public Long getContentLength() {
        return Files.size(this.path);
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        return FileChannelsAtNioPathKt.readChannel$default(this.path, 0L, 0L, null, 7, null);
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom(@NotNull LongRange range) {
        Intrinsics.checkNotNullParameter(range, "range");
        return FileChannelsAtNioPathKt.readChannel$default(this.path, range.getFirst(), range.getLast(), null, 4, null);
    }
}

