/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\b\u0010\u000b\u001a)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0002*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0011*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a#\u0010\u0018\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001aE\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u001aj\b\u0012\u0004\u0012\u00020\u0003`\u001b0\u00122\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a=\u0010 \u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\u001aj\b\u0012\u0004\u0012\u00020\u000e`\u001b0\u0012H\u0002\u00a2\u0006\u0004\b \u0010!\u001a+\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b#\u0010$\u001a+\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b%\u0010$\u001a\u001b\u0010&\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006("}, d2={"", "header", "", "Lio/ktor/http/HeaderValue;", "parseAndSortHeader", "(Ljava/lang/String;)Ljava/util/List;", "parseAndSortContentTypeHeader", "text", "parseHeaderValue", "", "parametersOnly", "(Ljava/lang/String;Z)Ljava/util/List;", "", "Lkotlin/Pair;", "Lio/ktor/http/HeaderValueParam;", "toHeaderParamsList", "(Ljava/lang/Iterable;)Ljava/util/List;", "T", "Lkotlin/Lazy;", "valueOrEmpty", "(Lkotlin/Lazy;)Ljava/util/List;", "", "start", "end", "subtrim", "(Ljava/lang/String;II)Ljava/lang/String;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "items", "parseHeaderValueItem", "(Ljava/lang/String;ILkotlin/Lazy;Z)I", "parameters", "parseHeaderValueParameter", "(Ljava/lang/String;ILkotlin/Lazy;)I", "value", "parseHeaderValueParameterValue", "(Ljava/lang/String;I)Lkotlin/Pair;", "parseHeaderValueParameterValueQuoted", "nextIsDelimiterOrEnd", "(Ljava/lang/String;I)Z", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHttpHeaderValueParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpHeaderValueParser.kt\nio/ktor/http/HttpHeaderValueParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1068#2:244\n1563#2:245\n1634#2,3:246\n*S KotlinDebug\n*F\n+ 1 HttpHeaderValueParser.kt\nio/ktor/http/HttpHeaderValueParserKt\n*L\n59#1:244\n115#1:245\n115#1:246,3\n*E\n"})
public final class HttpHeaderValueParserKt {
    @NotNull
    public static final List<HeaderValue> parseAndSortHeader(@Nullable String header) {
        Iterable $this$sortedByDescending$iv = HttpHeaderValueParserKt.parseHeaderValue(header);
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                HeaderValue it = (HeaderValue)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getQuality());
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseAndSortContentTypeHeader(@Nullable String header) {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                HeaderValue it = (HeaderValue)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getQuality());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    HeaderValue it = (HeaderValue)a;
                    boolean bl = false;
                    ContentType contentType = ContentType.Companion.parse(it.getValue());
                    int asterisks = 0;
                    if (Intrinsics.areEqual(contentType.getContentType(), "*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual(contentType.getContentSubtype(), "*")) {
                        ++asterisks;
                    }
                    it = (HeaderValue)b;
                    Comparable comparable = Integer.valueOf(asterisks);
                    bl = false;
                    contentType = ContentType.Companion.parse(it.getValue());
                    asterisks = 0;
                    if (Intrinsics.areEqual(contentType.getContentType(), "*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual(contentType.getContentSubtype(), "*")) {
                        ++asterisks;
                    }
                    n = ComparisonsKt.compareValues(comparable, asterisks);
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)HttpHeaderValueParserKt.parseHeaderValue(header), new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    HeaderValue it = (HeaderValue)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getParams().size());
                    it = (HeaderValue)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getParams().size());
                }
                return n;
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text2) {
        return HttpHeaderValueParserKt.parseHeaderValue(text2, false);
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text2, boolean parametersOnly) {
        if (text2 == null) {
            return CollectionsKt.emptyList();
        }
        int position = 0;
        Lazy<ArrayList> items = LazyKt.lazy(LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValue$lambda$4);
        while (position <= StringsKt.getLastIndex(text2)) {
            position = HttpHeaderValueParserKt.parseHeaderValueItem(text2, position, items, parametersOnly);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(items);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HeaderValueParam> toHeaderParamsList(@NotNull Iterable<Pair<String, String>> $this$toHeaderParamsList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderParamsList, "<this>");
        Iterable<Pair<String, String>> $this$map$iv = $this$toHeaderParamsList;
        boolean $i$f$map = false;
        Iterable<Pair<String, String>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HeaderValueParam((String)it.getFirst(), (String)it.getSecond()));
        }
        return (List)destination$iv$iv;
    }

    private static final <T> List<T> valueOrEmpty(Lazy<? extends List<? extends T>> $this$valueOrEmpty) {
        return $this$valueOrEmpty.isInitialized() ? $this$valueOrEmpty.getValue() : CollectionsKt.emptyList();
    }

    private static final String subtrim(String $this$subtrim, int start2, int end) {
        String string = $this$subtrim.substring(start2, end);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final int parseHeaderValueItem(String text2, int start2, Lazy<? extends ArrayList<HeaderValue>> items, boolean parametersOnly) {
        Integer valueEnd;
        int position = start2;
        Lazy<ArrayList> parameters = LazyKt.lazy(LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValueItem$lambda$6);
        Integer n = valueEnd = parametersOnly ? Integer.valueOf(position) : null;
        block4: while (position <= StringsKt.getLastIndex(text2)) {
            switch (text2.charAt(position)) {
                case ',': {
                    Integer n2 = valueEnd;
                    items.getValue().add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text2, start2, n2 != null ? n2 : position), HttpHeaderValueParserKt.valueOrEmpty(parameters)));
                    return position + 1;
                }
                case ';': {
                    if (valueEnd == null) {
                        valueEnd = position;
                    }
                    position = HttpHeaderValueParserKt.parseHeaderValueParameter(text2, position + 1, parameters);
                    continue block4;
                }
            }
            position = parametersOnly ? HttpHeaderValueParserKt.parseHeaderValueParameter(text2, position, parameters) : position + 1;
        }
        Integer n3 = valueEnd;
        items.getValue().add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text2, start2, n3 != null ? n3 : position), HttpHeaderValueParserKt.valueOrEmpty(parameters)));
        return position;
    }

    private static final int parseHeaderValueParameter(String text2, int start2, Lazy<? extends ArrayList<HeaderValueParam>> parameters) {
        int position;
        for (position = start2; position <= StringsKt.getLastIndex(text2); ++position) {
            switch (text2.charAt(position)) {
                case '=': {
                    Pair<Integer, String> pair2 = HttpHeaderValueParserKt.parseHeaderValueParameterValue(text2, position + 1);
                    int paramEnd = ((Number)pair2.component1()).intValue();
                    String paramValue = pair2.component2();
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text2, start2, position, paramValue);
                    return paramEnd;
                }
                case ',': 
                case ';': {
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text2, start2, position, "");
                    return position;
                }
            }
        }
        HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text2, start2, position, "");
        return position;
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValue(String value, int start2) {
        int position;
        if (value.length() == start2) {
            return TuplesKt.to(start2, "");
        }
        if (value.charAt(start2) == '\"') {
            return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(value, position + 1);
        }
        for (position = start2; position <= StringsKt.getLastIndex(value); ++position) {
            switch (value.charAt(position)) {
                case ',': 
                case ';': {
                    return TuplesKt.to(position, HttpHeaderValueParserKt.subtrim(value, start2, position));
                }
            }
        }
        return TuplesKt.to(position, HttpHeaderValueParserKt.subtrim(value, start2, position));
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String value, int start2) {
        int position = start2;
        StringBuilder builder2 = new StringBuilder();
        while (position <= StringsKt.getLastIndex(value)) {
            char currentChar = value.charAt(position);
            if (currentChar == '\"' && HttpHeaderValueParserKt.nextIsDelimiterOrEnd(value, position)) {
                return TuplesKt.to(position + 1, builder2.toString());
            }
            if (currentChar == '\\' && position < StringsKt.getLastIndex(value) - 2) {
                builder2.append(value.charAt(position + 1));
                position += 2;
                continue;
            }
            builder2.append(currentChar);
            ++position;
        }
        Integer n = position;
        char c = '\"';
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = string;
        return TuplesKt.to(n, c + string2);
    }

    private static final boolean nextIsDelimiterOrEnd(String $this$nextIsDelimiterOrEnd, int start2) {
        int position;
        for (position = start2 + 1; position < $this$nextIsDelimiterOrEnd.length() && $this$nextIsDelimiterOrEnd.charAt(position) == ' '; ++position) {
        }
        return position == $this$nextIsDelimiterOrEnd.length() || $this$nextIsDelimiterOrEnd.charAt(position) == ';' || $this$nextIsDelimiterOrEnd.charAt(position) == ',';
    }

    private static final ArrayList parseHeaderValue$lambda$4() {
        return new ArrayList();
    }

    private static final ArrayList parseHeaderValueItem$lambda$6() {
        return new ArrayList();
    }

    private static final void parseHeaderValueParameter$addParam(Lazy<? extends ArrayList<HeaderValueParam>> $parameters, String text2, int start2, int end, String value) {
        String name = HttpHeaderValueParserKt.subtrim(text2, start2, end);
        if (((CharSequence)name).length() == 0) {
            return;
        }
        $parameters.getValue().add(new HeaderValueParam(name, value));
    }
}

