/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets.progress;

import com.github.ajalt.mordant.internal.MppAtomicRef;
import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.widgets.progress.ProgressBarCell;
import com.github.ajalt.mordant.widgets.progress.ProgressBarDefinition;
import com.github.ajalt.mordant.widgets.progress.ProgressState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\"\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR,\u0010\u000b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/ajalt/mordant/widgets/progress/CachedProgressBarDefinition;", "T", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarDefinition;", "definition", "timeSource", "Lkotlin/time/TimeSource$WithComparableMarks;", "(Lcom/github/ajalt/mordant/widgets/progress/ProgressBarDefinition;Lkotlin/time/TimeSource$WithComparableMarks;)V", "alignColumns", "", "getAlignColumns", "()Z", "cache", "Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "", "", "Lkotlin/Pair;", "Lkotlin/time/ComparableTimeMark;", "Lcom/github/ajalt/mordant/rendering/Widget;", "cells", "", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarCell;", "getCells", "()Ljava/util/List;", "fps", "getFps", "()I", "spacing", "getSpacing", "invalidateCache", "", "isCacheValid", "cell", "lastFrameTime", "makeCell", "i", "mordant"})
@SourceDebugExtension(value={"SMAP\nCachedProgressBarDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedProgressBarDefinition.kt\ncom/github/ajalt/mordant/widgets/progress/CachedProgressBarDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1559#2:83\n1590#2,4:84\n1#3:88\n*S KotlinDebug\n*F\n+ 1 CachedProgressBarDefinition.kt\ncom/github/ajalt/mordant/widgets/progress/CachedProgressBarDefinition\n*L\n22#1:83\n22#1:84,4\n*E\n"})
public final class CachedProgressBarDefinition<T>
implements ProgressBarDefinition<T> {
    @NotNull
    private final TimeSource.WithComparableMarks timeSource;
    @NotNull
    private final MppAtomicRef<Map<Integer, Pair<ComparableTimeMark, Widget>>> cache;
    @NotNull
    private final List<ProgressBarCell<T>> cells;
    private final int spacing;
    private final boolean alignColumns;
    private final int fps;

    /*
     * WARNING - void declaration
     */
    public CachedProgressBarDefinition(@NotNull ProgressBarDefinition<T> definition, @NotNull TimeSource.WithComparableMarks timeSource) {
        Comparable comparable;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(timeSource, "timeSource");
        this.timeSource = timeSource;
        this.cache = MppImplKt.MppAtomicRef(MapsKt.emptyMap());
        Iterable iterable = definition.getCells();
        CachedProgressBarDefinition cachedProgressBarDefinition = this;
        boolean $i$f$mapIndexed = false;
        Iterator iterator2 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void it;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProgressBarCell progressBarCell = (ProgressBarCell)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.makeCell((int)i, (ProgressBarCell<T>)it));
        }
        cachedProgressBarDefinition.cells = (List)destination$iv$iv;
        this.spacing = definition.getSpacing();
        this.alignColumns = definition.getAlignColumns();
        Iterable iterable2 = definition.getCells();
        cachedProgressBarDefinition = this;
        iterator2 = iterable2.iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            ProgressBarCell it = (ProgressBarCell)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getFps());
            while (iterator2.hasNext()) {
                ProgressBarCell it2 = (ProgressBarCell)iterator2.next();
                $i$a$-maxOfOrNull-CachedProgressBarDefinition$fps$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getFps());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        cachedProgressBarDefinition.fps = n != null ? n : 0;
    }

    @Override
    @NotNull
    public List<ProgressBarCell<T>> getCells() {
        return this.cells;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public boolean getAlignColumns() {
        return this.alignColumns;
    }

    public final void invalidateCache() {
        this.cache.getAndSet(MapsKt.emptyMap());
    }

    public final int getFps() {
        return this.fps;
    }

    private final ProgressBarCell<T> makeCell(int i, ProgressBarCell<T> cell2) {
        return new ProgressBarCell(cell2.getColumnWidth(), cell2.getFps(), cell2.getAlign(), cell2.getVerticalAlign(), new Function1<ProgressState<T>, Widget>(this, i, cell2){
            final /* synthetic */ CachedProgressBarDefinition<T> this$0;
            final /* synthetic */ int $i;
            final /* synthetic */ ProgressBarCell<T> $cell;
            {
                this.this$0 = $receiver;
                this.$i = $i;
                this.$cell = $cell;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Widget invoke(@NotNull ProgressState<T> $this$$receiver) {
                Map<Integer, Pair<ComparableTimeMark, Widget>> newValue$iv;
                T old$iv;
                block5: {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    MppAtomicRef mppAtomicRef = CachedProgressBarDefinition.access$getCache$p(this.this$0);
                    CachedProgressBarDefinition<T> cachedProgressBarDefinition = this.this$0;
                    ProgressBarCell<T> progressBarCell = this.$cell;
                    int n = this.$i;
                    int attempts$iv = 99;
                    boolean $i$f$update = false;
                    for (int i = 0; i < attempts$iv; ++i) {
                        Map<Integer, Pair<ComparableTimeMark, Widget>> map2;
                        void $this$update_u24default$iv;
                        int it$iv = i;
                        boolean bl = false;
                        old$iv = $this$update_u24default$iv.getValue();
                        Map<Integer, Pair<ComparableTimeMark, Widget>> $this$invoke_u24lambda_u240 = (Map<Integer, Pair<ComparableTimeMark, Widget>>)old$iv;
                        boolean bl2 = false;
                        Pair pair2 = (Pair)$this$invoke_u24lambda_u240.get(n);
                        if (CachedProgressBarDefinition.access$isCacheValid(cachedProgressBarDefinition, progressBarCell, pair2 != null ? (ComparableTimeMark)pair2.getFirst() : null)) {
                            map2 = $this$invoke_u24lambda_u240;
                        } else {
                            Widget content2 = progressBarCell.getContent().invoke($this$$receiver);
                            map2 = MapsKt.plus($this$invoke_u24lambda_u240, TuplesKt.to(n, TuplesKt.to(CachedProgressBarDefinition.access$getTimeSource$p(cachedProgressBarDefinition).markNow(), content2)));
                        }
                        if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv = map2)) {
                            continue;
                        }
                        break block5;
                    }
                    throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
                }
                Map map3 = TuplesKt.to(old$iv, newValue$iv).component2();
                Object object = (Pair)map3.get(this.$i);
                if (object == null || (object = (Widget)((Pair)object).getSecond()) == null) {
                    object = this.$cell.getContent().invoke($this$$receiver);
                }
                return object;
            }
        });
    }

    private final boolean isCacheValid(ProgressBarCell<T> cell2, ComparableTimeMark lastFrameTime) {
        if (lastFrameTime == null) {
            return false;
        }
        long timeSinceLastFrame = lastFrameTime.elapsedNow-UwyO8pc();
        long maxCacheRetentionDuration = DurationKt.toDuration(1.0 / (double)cell2.getFps(), DurationUnit.SECONDS);
        return Duration.compareTo-LRDsOJo(timeSinceLastFrame, maxCacheRetentionDuration) < 0;
    }

    public static final /* synthetic */ MppAtomicRef access$getCache$p(CachedProgressBarDefinition $this) {
        return $this.cache;
    }

    public static final /* synthetic */ boolean access$isCacheValid(CachedProgressBarDefinition $this, ProgressBarCell cell2, ComparableTimeMark lastFrameTime) {
        return $this.isCacheValid(cell2, lastFrameTime);
    }

    public static final /* synthetic */ TimeSource.WithComparableMarks access$getTimeSource$p(CachedProgressBarDefinition $this) {
        return $this.timeSource;
    }
}

