/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.internal.ThemeString;
import com.github.ajalt.mordant.internal.ThemeStyle;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.rendering.WidthRangeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/ajalt/mordant/widgets/UnorderedList;", "Lcom/github/ajalt/mordant/rendering/Widget;", "listEntries", "", "bulletText", "", "bulletStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "(Ljava/util/List;Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "Lcom/github/ajalt/mordant/internal/ThemeString;", "Lcom/github/ajalt/mordant/internal/ThemeStyle;", "(Ljava/util/List;Lcom/github/ajalt/mordant/internal/ThemeString;Lcom/github/ajalt/mordant/internal/ThemeStyle;)V", "bullet", "Lcom/github/ajalt/mordant/rendering/Line;", "t", "Lcom/github/ajalt/mordant/rendering/Theme;", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
@SourceDebugExtension(value={"SMAP\nUnorderedList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnorderedList.kt\ncom/github/ajalt/mordant/widgets/UnorderedList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class UnorderedList
implements Widget {
    @NotNull
    private final List<Widget> listEntries;
    @NotNull
    private final ThemeString bulletText;
    @NotNull
    private final ThemeStyle bulletStyle;

    private UnorderedList(List<? extends Widget> listEntries, ThemeString bulletText, ThemeStyle bulletStyle) {
        this.listEntries = listEntries;
        this.bulletText = bulletText;
        this.bulletStyle = bulletStyle;
    }

    public UnorderedList(@NotNull List<? extends Widget> listEntries, @Nullable String bulletText, @Nullable TextStyle bulletStyle) {
        Intrinsics.checkNotNullParameter(listEntries, "listEntries");
        this(listEntries, ThemeString.Companion.of$default(ThemeString.Companion, "list.bullet.text", bulletText, null, 4, null), ThemeStyle.Companion.of$default(ThemeStyle.Companion, "list.bullet", bulletStyle, null, 4, null));
    }

    public /* synthetic */ UnorderedList(List list, String string, TextStyle textStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            textStyle = null;
        }
        this((List<? extends Widget>)list, string, textStyle);
    }

    private final Line bullet(Theme t) {
        String text2 = this.bulletText.get(t);
        if (!(!StringsKt.contains$default((CharSequence)text2, "\n", false, 2, null))) {
            boolean bl = false;
            String string = "bullet text cannot contain newlines";
            throw new IllegalArgumentException(string.toString());
        }
        if (((CharSequence)text2).length() == 0) {
            return ConstantsKt.getEMPTY_LINE();
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = ConstantsKt.getSINGLE_SPACE();
        Line line = CollectionsKt.firstOrNull(ParsingKt.parseText(text2, this.bulletStyle.get(t)).getLines());
        if (line == null) {
            line = ConstantsKt.getEMPTY_LINE();
        }
        objectArray[1] = line;
        objectArray[2] = ConstantsKt.getSINGLE_SPACE();
        return LinesKt.flatLine(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        Iterable iterable = this.bullet(t.getTheme());
        int n = 0;
        for (Object t2 : iterable) {
            void it;
            Span span = (Span)t2;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getCellWidth$mordant();
            n = n2 + n3;
        }
        int bulletWidth = n;
        return WidthRangeKt.maxWidthRange((Iterable<? extends Widget>)this.listEntries, t, width, bulletWidth);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        Line bullet = this.bullet(t.getTheme());
        Iterable iterable = bullet;
        int n = 0;
        for (Object object : iterable) {
            void it;
            Span span = (Span)object;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getCellWidth$mordant();
            n = n2 + n3;
        }
        int bulletWidth = n;
        int contentWidth = RangesKt.coerceAtLeast(width - bulletWidth, 0);
        List continuationPadding = bulletWidth > 0 ? CollectionsKt.listOf(Span.Companion.space(bulletWidth, this.bulletStyle.get(t.getTheme()))) : (List)ConstantsKt.getEMPTY_LINE();
        List lines = new ArrayList();
        for (Widget entry : this.listEntries) {
            Iterator<Line> iterator2 = entry.render(t, contentWidth).getLines().iterator();
            int n4 = 0;
            while (iterator2.hasNext()) {
                int i = n4++;
                Line line = iterator2.next();
                List start2 = i == 0 ? (List)bullet : continuationPadding;
                ((Collection)lines).add(new Line(CollectionsKt.plus((Collection)start2, (Iterable)line)));
            }
        }
        return new Lines(lines);
    }
}

