/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BM\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010\u0019\u001a\u00020\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010$\u001a\u00020\bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalRecorder;", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "width", "", "height", "hyperlinks", "", "outputInteractive", "inputInteractive", "crClearsLine", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;IIZZZZ)V", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;)V", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "inputLines", "", "", "getInputLines", "()Ljava/util/List;", "setInputLines", "(Ljava/util/List;)V", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "stderr", "stdout", "clearOutput", "", "completePrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "readLineOrNull", "hideInput", "mordant"})
public final class TerminalRecorder
implements TerminalInterface {
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private List<String> inputLines;
    @NotNull
    private final StringBuilder stdout;
    @NotNull
    private final StringBuilder stderr;
    @NotNull
    private final StringBuilder output;

    private TerminalRecorder(TerminalInfo info) {
        this.info = info;
        this.inputLines = new ArrayList();
        this.stdout = new StringBuilder();
        this.stderr = new StringBuilder();
        this.output = new StringBuilder();
    }

    @Override
    @NotNull
    public TerminalInfo getInfo() {
        return this.info;
    }

    public TerminalRecorder(@NotNull AnsiLevel ansiLevel, int width, int height, boolean hyperlinks, boolean outputInteractive, boolean inputInteractive, boolean crClearsLine) {
        Intrinsics.checkNotNullParameter((Object)ansiLevel, "ansiLevel");
        this(new TerminalInfo(width, height, ansiLevel, hyperlinks, outputInteractive, inputInteractive, crClearsLine));
    }

    public /* synthetic */ TerminalRecorder(AnsiLevel ansiLevel, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            ansiLevel = AnsiLevel.TRUECOLOR;
        }
        if ((n3 & 2) != 0) {
            n = 79;
        }
        if ((n3 & 4) != 0) {
            n2 = 24;
        }
        if ((n3 & 8) != 0) {
            boolean bl5 = bl = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x10) != 0) {
            boolean bl6 = bl2 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x20) != 0) {
            boolean bl7 = bl3 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x40) != 0) {
            bl4 = false;
        }
        this(ansiLevel, n, n2, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final List<String> getInputLines() {
        return this.inputLines;
    }

    public final void setInputLines(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.inputLines = list;
    }

    public final void clearOutput() {
        StringsKt.clear(this.stdout);
        StringsKt.clear(this.stderr);
        StringsKt.clear(this.output);
    }

    @NotNull
    public final String stdout() {
        String string = this.stdout.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String stderr() {
        String string = this.stderr.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String output() {
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public void completePrintRequest(@NotNull PrintRequest request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        StringBuilder sb = request2.getStderr() ? this.stderr : this.stdout;
        sb.append(request2.getText());
        this.output.append(request2.getText());
        if (request2.getTrailingLinebreak()) {
            sb.append("\n");
            this.output.append("\n");
        }
    }

    @Override
    @Nullable
    public String readLineOrNull(boolean hideInput) {
        return CollectionsKt.removeFirstOrNull(this.inputLines);
    }
}

