/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.VerticalAlign;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.CellBuilderInstance;
import com.github.ajalt.mordant.table.CellContent;
import com.github.ajalt.mordant.table.CellStyleBuilder;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.RowBuilderInstance;
import com.github.ajalt.mordant.table.SectionBuilderInstance;
import com.github.ajalt.mordant.table.TableBuilderInstance;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.table.TableImpl;
import com.github.ajalt.mordant.table.TableLayout;
import com.github.ajalt.mordant.table.TableLayoutKt;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.PaddingKt;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00062\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/table/TableLayout;", "", "table", "Lcom/github/ajalt/mordant/table/TableBuilderInstance;", "(Lcom/github/ajalt/mordant/table/TableBuilderInstance;)V", "buildSection", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/MutableRow;", "section", "Lcom/github/ajalt/mordant/table/SectionBuilderInstance;", "builderWidth", "", "buildTable", "Lcom/github/ajalt/mordant/table/TableImpl;", "insertCell", "", "cell", "Lcom/github/ajalt/mordant/table/CellBuilderInstance;", "rows", "startingX", "startingY", "mordant"})
@SourceDebugExtension(value={"SMAP\nTableLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableLayout.kt\ncom/github/ajalt/mordant/table/TableLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Padding.kt\ncom/github/ajalt/mordant/widgets/Padding$Companion\n*L\n1#1,204:1\n1#2:205\n12#3,2:206\n*S KotlinDebug\n*F\n+ 1 TableLayout.kt\ncom/github/ajalt/mordant/table/TableLayout\n*L\n103#1:206,2\n*E\n"})
public final class TableLayout {
    @NotNull
    private final TableBuilderInstance table;

    public TableLayout(@NotNull TableBuilderInstance table) {
        Intrinsics.checkNotNullParameter(table, "table");
        this.table = table;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TableImpl buildTable() {
        int n;
        int n2;
        Object object;
        int it2;
        Iterator<Object> r;
        Iterator<Object> iterator2;
        SectionBuilderInstance[] sectionBuilderInstanceArray = new SectionBuilderInstance[]{this.table.getHeaderSection(), this.table.getBodySection(), this.table.getFooterSection()};
        Iterator iterator3 = ((Iterable)CollectionsKt.listOf(sectionBuilderInstanceArray)).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        SectionBuilderInstance it2 = (SectionBuilderInstance)iterator3.next();
        boolean bl = false;
        Iterator iterator4 = ((Iterable)it2.getRows()).iterator();
        if (!iterator4.hasNext()) {
            iterator2 = null;
        } else {
            r = (RowBuilderInstance)iterator4.next();
            boolean bl2 = false;
            r = ((RowBuilderInstance)((Object)r)).getCells().size();
            while (iterator4.hasNext()) {
                Object r2 = (RowBuilderInstance)iterator4.next();
                bl3 = false;
                if (r.compareTo((Object)(r2 = (Comparable)Integer.valueOf(((RowBuilderInstance)r2).getCells().size()))) >= 0) continue;
                r = r2;
            }
            iterator2 = r;
        }
        Integer n3 = (Integer)((Object)iterator2);
        int n4 = it2 = n3 != null ? n3 : 0;
        while (iterator3.hasNext()) {
            Object object2;
            SectionBuilderInstance it222 = (SectionBuilderInstance)iterator3.next();
            $i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = false;
            r = ((Iterable)it222.getRows()).iterator();
            if (!r.hasNext()) {
                object2 = null;
            } else {
                Object r3 = (RowBuilderInstance)r.next();
                boolean bl3 = false;
                r3 = ((RowBuilderInstance)r3).getCells().size();
                while (r.hasNext()) {
                    Object r4 = (RowBuilderInstance)r.next();
                    $i$a$-maxOfOrNull-TableLayout$buildTable$builderWidth$1$1 = false;
                    if (r3.compareTo(r4 = (Comparable)Integer.valueOf(((RowBuilderInstance)r4).getCells().size())) >= 0) continue;
                    r3 = r4;
                }
                object2 = r3;
            }
            Integer n5 = (Integer)object2;
            int it222 = n5 != null ? n5 : 0;
            if (it2 >= it222) continue;
            it2 = it222;
        }
        int builderWidth = it2;
        List<List<Cell>> header = this.buildSection(this.table.getHeaderSection(), builderWidth);
        List<List<Cell>> body2 = this.buildSection(this.table.getBodySection(), builderWidth);
        List<List<Cell>> footer = this.buildSection(this.table.getFooterSection(), builderWidth);
        Object $i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = new List[]{header, body2, footer};
        if (($i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = (Collection)CollectionsKt.flatten((Iterable)CollectionsKt.listOf($i$a$-maxOf-TableLayout$buildTable$builderWidth$2))).isEmpty()) {
            boolean bl4 = false;
            Borders borders2 = this.table.getTableBorders();
            if (borders2 == null) {
                borders2 = Borders.ALL;
            }
            Borders b = borders2;
            Cell.Content cell2 = new Cell.Content(EmptyWidget.INSTANCE, 1, 1, b.getLeft(), b.getTop(), b.getRight(), b.getBottom(), null, TextAlign.LEFT, VerticalAlign.TOP, 0);
            object = CollectionsKt.listOf(CollectionsKt.listOf(cell2));
        } else {
            object = $i$a$-maxOf-TableLayout$buildTable$builderWidth$2;
        }
        List rows = (List)object;
        Object object3 = ((Iterable)rows).iterator();
        if (!object3.hasNext()) {
            throw new NoSuchElementException();
        }
        List it3 = (List)object3.next();
        boolean bl5 = false;
        int n6 = it3.size();
        while (object3.hasNext()) {
            List it4 = (List)object3.next();
            n2 = 0;
            n = it4.size();
            if (n6 >= n) continue;
            n6 = n;
        }
        int columnCount = n6;
        object3 = new ArrayList(columnCount);
        for (n6 = 0; n6 < columnCount; ++n6) {
            void i;
            n2 = n = n6;
            Object object4 = object3;
            boolean bl6 = false;
            ColumnBuilder columnBuilder = this.table.getColumns().get((int)i);
            ((ArrayList)object4).add(TableDslKt.toCustom(columnBuilder != null ? columnBuilder.getWidth() : null));
        }
        List columnWidths = (List)object3;
        return new TableImpl(rows, this.table.getBorderType(), this.table.getBorderStyle(), header.size(), footer.size(), columnWidths, this.table.getTableBorders(), this.table.getAddPaddingWidthToFixedWidth());
    }

    private final List<List<Cell>> buildSection(SectionBuilderInstance section, int builderWidth) {
        int n = section.getRows().size();
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList(section.getRows().size()));
        }
        List rows = arrayList;
        Iterator<RowBuilderInstance> iterator2 = section.getRows().iterator();
        int n5 = 0;
        while (iterator2.hasNext()) {
            int y = n5++;
            RowBuilderInstance row2 = iterator2.next();
            int x = 0;
            for (CellBuilderInstance cellBuilder : row2.getCells()) {
                x = TableLayoutKt.access$findEmptyColumn(rows, x, y);
                this.insertCell(cellBuilder, section, rows, x, y, builderWidth);
                ++x;
            }
        }
        return rows;
    }

    /*
     * WARNING - void declaration
     */
    private final void insertCell(CellBuilderInstance cell2, SectionBuilderInstance section, List<List<Cell>> rows, int startingX, int startingY, int builderWidth) {
        Widget widget2;
        void $this$insertCell_u24lambda_u247;
        Padding.Builder builder2;
        Comparable comparable;
        ColumnBuilder tableCol = this.table.getColumns().get(startingX);
        CellStyleBuilder sectionCol = section.getColumns().get(startingX);
        RowBuilderInstance row2 = section.getRows().get(startingY);
        Iterator iterator2 = ((Iterable)RangesKt.until(startingY, startingY + cell2.getRowSpan())).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            int it22 = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Object object = CollectionsKt.getOrNull(section.getRows(), it22);
            Comparable it22 = Integer.valueOf(object != null && (object = ((RowBuilderInstance)object).getCells()) != null ? object.size() : 0);
            while (iterator2.hasNext()) {
                int it32 = ((IntIterator)iterator2).nextInt();
                $i$a$-maxOfOrNull-TableLayout$insertCell$maxRowSize$1 = false;
                Object object2 = CollectionsKt.getOrNull(section.getRows(), it32);
                Comparable it32 = Integer.valueOf(object2 != null && (object2 = ((RowBuilderInstance)object2).getCells()) != null ? object2.size() : 0);
                if (it22.compareTo(it32) >= 0) continue;
                it22 = it32;
            }
            comparable = it22;
        }
        Integer n = (Integer)comparable;
        int maxRowSize = n != null ? n : 0;
        int columnSpan = RangesKt.coerceAtMost(cell2.getColumnSpan(), builderWidth - maxRowSize + 1);
        int rowSpan = RangesKt.coerceAtMost(cell2.getRowSpan(), rows.size() - startingY);
        Borders borders2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Borders.ALL, insertCell.borders.1.INSTANCE);
        Padding.Companion this_$iv = Padding.Companion;
        boolean $i$f$invoke = false;
        Padding.Builder builder3 = builder2 = new Padding.Builder(0, 0, 0, 0);
        Object object = this;
        SectionBuilderInstance sectionBuilderInstance = section;
        ColumnBuilder columnBuilder = tableCol;
        Object object3 = sectionCol;
        RowBuilderInstance rowBuilderInstance = row2;
        CellBuilderInstance cellBuilderInstance = cell2;
        boolean bl = false;
        $this$insertCell_u24lambda_u247.setHorizontal(1);
        Object object4 = Unit.INSTANCE;
        Padding.Builder b$iv = builder2;
        Padding padding2 = TableLayout.insertCell$getStyle(cellBuilderInstance, rowBuilderInstance, (CellStyleBuilder)object3, columnBuilder, sectionBuilderInstance, (TableLayout)object, new Padding(b$iv.getTop(), b$iv.getRight(), b$iv.getBottom(), b$iv.getLeft()), insertCell.padding.2.INSTANCE);
        Whitespace whitespace2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Whitespace.PRE, insertCell.whitespace.1.INSTANCE);
        TextAlign textAlign2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, TextAlign.NONE, insertCell.textAlign.1.INSTANCE);
        VerticalAlign verticalAlign2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, VerticalAlign.TOP, insertCell.verticalAlign.1.INSTANCE);
        OverflowWrap overflowWrap2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, OverflowWrap.ELLIPSES, insertCell.overflowWrap.1.INSTANCE);
        TextStyle stripedStyle = !((Collection)section.getRowStyles()).isEmpty() ? section.getRowStyles().get(startingY % section.getRowStyles().size()) : null;
        TextStyle[] textStyleArray = new TextStyle[7];
        textStyleArray[0] = cell2.getStyle();
        textStyleArray[1] = row2.getStyle();
        textStyleArray[2] = stripedStyle;
        CellStyleBuilder cellStyleBuilder = sectionCol;
        textStyleArray[3] = cellStyleBuilder != null ? cellStyleBuilder.getStyle() : null;
        ColumnBuilder columnBuilder2 = tableCol;
        textStyleArray[4] = columnBuilder2 != null ? columnBuilder2.getStyle() : null;
        textStyleArray[5] = section.getStyle();
        textStyleArray[6] = this.table.getStyle();
        TextStyle style = TextStyleKt.foldStyles(textStyleArray);
        CellContent cellContent = cell2.getContent();
        if (cellContent instanceof CellContent.WidgetContent) {
            widget2 = ((CellContent.WidgetContent)cell2.getContent()).getWidget();
        } else if (cellContent instanceof CellContent.TextContent) {
            widget2 = new Text(((CellContent.TextContent)cell2.getContent()).getText(), whitespace2, textAlign2, overflowWrap2, null, null, 48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Widget content2 = PaddingKt.withPadding$default(widget2, padding2, false, 2, null);
        Boolean bl2 = borders2.getRight();
        boolean bl3 = bl2;
        object4 = borders2.getTop();
        object = borders2.getLeft();
        int n2 = columnSpan;
        int n3 = rowSpan;
        object3 = content2;
        boolean bl4 = false;
        boolean bl5 = columnSpan == 1;
        Boolean bl6 = bl5 ? bl2 : null;
        bl2 = borders2.getBottom();
        boolean it = bl2;
        Boolean bl7 = bl6;
        boolean bl8 = false;
        boolean bl9 = rowSpan == 1;
        int n4 = padding2.getLeft() + padding2.getRight();
        VerticalAlign verticalAlign3 = verticalAlign2;
        TextAlign textAlign3 = textAlign2;
        TextStyle textStyle = style;
        Boolean bl10 = bl9 ? bl2 : null;
        Boolean bl11 = bl7;
        Object object5 = object4;
        Object object6 = object;
        int n5 = n2;
        int n6 = n3;
        Object object7 = object3;
        Cell.Content builtCell = new Cell.Content((Widget)object7, n6, n5, (Boolean)object6, (Boolean)object5, bl11, bl10, textStyle, textAlign3, verticalAlign3, n4);
        int lastX = startingX + columnSpan - 1;
        int x = startingX;
        if (x <= lastX) {
            while (true) {
                int lastY;
                int y;
                if ((y = startingY) <= (lastY = startingY + rowSpan - 1)) {
                    while (true) {
                        Cell cell3;
                        if (x == startingX && y == startingY) {
                            cell3 = builtCell;
                        } else {
                            Boolean bl12 = borders2.getLeft();
                            boolean bl13 = bl12;
                            object3 = builtCell;
                            boolean bl14 = false;
                            boolean bl15 = x == startingX;
                            Boolean bl16 = bl15 ? bl12 : null;
                            bl12 = borders2.getTop();
                            boolean it2 = bl12;
                            Boolean bl17 = bl16;
                            boolean bl18 = false;
                            boolean bl19 = y == startingY;
                            Boolean bl20 = bl19 ? bl12 : null;
                            bl12 = borders2.getRight();
                            it2 = bl12;
                            Boolean bl21 = bl20;
                            boolean bl22 = false;
                            boolean bl23 = x == lastX;
                            Boolean bl24 = bl23 ? bl12 : null;
                            bl12 = borders2.getBottom();
                            it2 = bl12;
                            object = bl24;
                            boolean bl25 = false;
                            object4 = y == lastY;
                            Boolean bl26 = ((Boolean)object4).booleanValue() ? bl12 : null;
                            Object object8 = object;
                            Boolean bl27 = bl21;
                            Boolean bl28 = bl17;
                            Object object9 = object3;
                            cell3 = new Cell.SpanRef((Cell.Content)object9, bl28, bl27, (Boolean)object8, bl26);
                        }
                        Cell c = cell3;
                        List tableRow = TableLayoutKt.access$getRow(rows, y);
                        Cell existing = TableLayoutKt.access$getCell(tableRow, x);
                        if (!(existing == Cell.Empty.INSTANCE)) {
                            boolean bl29 = false;
                            String string = "Invalid table: cell spans cannot overlap";
                            throw new IllegalArgumentException(string.toString());
                        }
                        tableRow.set(x, c);
                        if (y == lastY) break;
                        ++y;
                    }
                }
                if (x == lastX) break;
                ++x;
            }
        }
    }

    private static final <T> T insertCell$getStyle(CellBuilderInstance $cell, RowBuilderInstance row2, CellStyleBuilder sectionCol, ColumnBuilder tableCol, SectionBuilderInstance $section, TableLayout this$0, T t, Function1<? super CellStyleBuilder, ? extends T> getter2) {
        T t2 = getter2.invoke($cell);
        if (t2 == null && (t2 = getter2.invoke(row2)) == null) {
            CellStyleBuilder cellStyleBuilder = sectionCol;
            t2 = cellStyleBuilder != null ? getter2.invoke(cellStyleBuilder) : null;
            if (t2 == null) {
                ColumnBuilder columnBuilder = tableCol;
                t2 = columnBuilder != null ? getter2.invoke(columnBuilder) : null;
                if (t2 == null && (t2 = getter2.invoke($section)) == null && (t2 = getter2.invoke(this$0.table)) == null) {
                    t2 = t;
                }
            }
        }
        return t2;
    }
}

