/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.internal.gen.CellWidthTableEntry;
import com.github.ajalt.mordant.internal.gen.CellwidthtableKt;
import com.github.ajalt.mordant.internal.gen.EmojiseqtableKt;
import com.github.ajalt.mordant.internal.gen.IntTrie;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"cellWidth", "", "codepoint", "stringCellWidth", "string", "", "mordant"})
public final class CellwidthKt {
    public static final int cellWidth(int codepoint) {
        boolean bl = 32 <= codepoint ? codepoint < 127 : false;
        if (bl) {
            return 1;
        }
        switch (codepoint) {
            case 8: 
            case 127: {
                return -1;
            }
        }
        CellWidthTableEntry[] table = CellwidthtableKt.getCELL_WIDTH_TABLE();
        int min = 0;
        int mid = 0;
        int max = ArraysKt.getLastIndex(table);
        if (codepoint < table[0].getLow() || codepoint > table[max].getHigh()) {
            return 1;
        }
        while (max >= min) {
            mid = (min + max) / 2;
            CellWidthTableEntry entry = table[mid];
            if (codepoint > entry.getHigh()) {
                min = mid + 1;
                continue;
            }
            if (codepoint < entry.getLow()) {
                max = mid - 1;
                continue;
            }
            return table[mid].getWidth();
        }
        return 1;
    }

    public static final int stringCellWidth(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        int sum = 0;
        int sumSinceZwj = 0;
        IntTrie zwjSeq = null;
        Iterator<Integer> iterator2 = MppImplKt.codepointSequence(string).iterator();
        while (iterator2.hasNext()) {
            int codepoint = ((Number)iterator2.next()).intValue();
            int width = CellwidthKt.cellWidth(codepoint);
            if (zwjSeq != null) {
                sumSinceZwj += width;
                if (zwjSeq.getValues().contains(codepoint)) {
                    sumSinceZwj = 0;
                }
                if ((zwjSeq = zwjSeq.getChildren().get(codepoint)) == null) {
                    sum += sumSinceZwj + 2;
                    sumSinceZwj = 0;
                    continue;
                }
                sumSinceZwj += width;
                continue;
            }
            if (EmojiseqtableKt.couldStartEmojiSeq(codepoint)) {
                zwjSeq = EmojiseqtableKt.getEMOJI_SEQUENCES().getChildren().get(codepoint);
            }
            if (zwjSeq != null) continue;
            sum += width;
        }
        return sum + sumSinceZwj;
    }
}

